/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.sdk.ui.wizard.menu;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.operation.MenuNewOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutProposalUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.IStructuredType.CATEGORIES;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;

/**
 * <h3>DesktopMenuNewWizard</h3> ...
 * 
 * @author Andreas Hoegger
 * @since 1.0.8 30.06.2010
 */
public class DesktopMenuNewWizard extends AbstractWorkspaceWizard {

  private MenuNewWizardPage m_page1;
  private IType m_declaringType;
  private MenuNewOperation m_operation;

  public DesktopMenuNewWizard() {
    setWindowTitle("New Desktop Menu");
  }

  public void initWizard(IType declaringType) {
    m_declaringType = declaringType;
    m_page1 = new MenuNewWizardPage(getDeclaringType());
    addPage(m_page1);
  }

  public void setSuperType(IType superType) {
    m_page1.setSuperType(ScoutProposalUtility.getScoutTypeProposalsFor(superType)[0]);
  }

  /**
   * @return the declaringType
   */
  public IType getDeclaringType() {
    return m_declaringType;
  }

  @Override
  protected boolean performFinish(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
    // create menu
    m_operation = new MenuNewOperation(getDeclaringType(), true);
    // write back members
    if (m_page1.getNlsName() != null) {
      m_operation.setNlsEntry(m_page1.getNlsName().getNlsEntry());
    }
    m_operation.setTypeName(m_page1.getTypeName());
    ITypeProposal superTypeProp = m_page1.getSuperType();
    if (superTypeProp != null) {
      String signature = Signature.createTypeSignature(superTypeProp.getType().getFullyQualifiedName(), true);
      m_operation.setSuperTypeSignature(signature);
    }
    if (m_page1.getSibling() == SiblingProposal.SIBLING_END) {
      IStructuredType structuredType = SdkTypeUtility.createStructuredDesktop(m_declaringType);
      m_operation.setSibling(structuredType.getSibling(CATEGORIES.TYPE_MENU));
    }
    else {
      m_operation.setSibling(m_page1.getSibling().getScoutType());
    }
    if (m_page1.getFormToOpen() != null) {
      m_operation.setFormToOpen(m_page1.getFormToOpen().getType());
    }
    m_operation.run(monitor, workingCopyManager);
    return true;
  }

  @Override
  protected void postFinishDisplayThread() {
    IType createdField = m_operation.getCreatedMenu();
    if (TypeUtility.exists(createdField)) {
      ScoutSdkUi.showJavaElementInEditor(createdField, false);
    }
  }
}
