/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.LogStatus;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.operation.form.formdata.ICreateFormDataRequest;
import org.eclipse.scout.sdk.ui.IScoutConstants;
import org.eclipse.scout.sdk.ui.SdkIcons;
import org.eclipse.scout.sdk.ui.internal.CreateFormDataRequest;
import org.eclipse.scout.sdk.ui.internal.ImageRegistry;
import org.eclipse.scout.sdk.ui.view.outline.IScoutExplorerPart;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ScoutSdkUi
extends AbstractUIPlugin
implements SdkIcons {
    public static final String PLUGIN_ID = "org.eclipse.scout.sdk.ui";
    public static final String LOG_LEVEL = "org.eclipse.scout.sdk.ui.loglevel";
    private static ScoutSdkUi plugin;
    public static final String PROPERTY_RELEASE_NOTES = "org.eclipse.scout.sdk.ui.releaseNotes";
    private static String PROPERTY_PLUGIN_VERSION;
    private static final String IMAGE_PATH = "resources/icons/";
    public static final String COLOR_INACTIVE_FOREGROUND = "inactiveForeground";
    public static final String FONT_SYSTEM_BOLD = "fontSystemBold";
    private ColorRegistry m_colorRegistry;
    private FontRegistry m_fontRegistry;
    private ServiceRegistration m_formDataServiceRegistration;
    private IPropertyChangeListener m_preferencesPropertyListener;
    private int m_loglevel;

    static {
        PROPERTY_PLUGIN_VERSION = "pluginVersion";
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.m_loglevel = this.parseLogLevel(context.getProperty(LOG_LEVEL));
        plugin = this;
        CreateFormDataRequest requestService = new CreateFormDataRequest();
        if (this.m_formDataServiceRegistration == null) {
            this.m_formDataServiceRegistration = context.registerService(ICreateFormDataRequest.class.getName(), (Object)requestService, null);
        }
        if (this.m_preferencesPropertyListener == null) {
            this.m_preferencesPropertyListener = new P_PreferenceStorePropertyListener();
        }
        this.getPreferenceStore().setDefault("org.eclipse.scout.sdk.propFormdataAutoUpdate", true);
        ScoutSdk.getDefault().setFormDataAutoUpdate(this.getPreferenceStore().getBoolean("org.eclipse.scout.sdk.propFormdataAutoUpdate"));
        this.getPreferenceStore().addPropertyChangeListener(this.m_preferencesPropertyListener);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.m_preferencesPropertyListener != null) {
            this.getPreferenceStore().removePropertyChangeListener(this.m_preferencesPropertyListener);
            this.m_preferencesPropertyListener = null;
        }
        super.stop(context);
        if (this.m_formDataServiceRegistration != null) {
            this.m_formDataServiceRegistration.unregister();
            this.m_formDataServiceRegistration = null;
        }
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static IWorkbenchWindow getWorkbenchWindow() {
        return ScoutSdkUi.getDefault().getWorkbenchWindowImpl();
    }

    public IWorkbenchWindow getWorkbenchWindowImpl() {
        IWorkbenchWindow activeWorkbenchWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow;
        }
        IWorkbenchWindow[] workbenchWindows = this.getWorkbench().getWorkbenchWindows();
        if (workbenchWindows.length > 0) {
            return workbenchWindows[0];
        }
        return null;
    }

    public static Shell getShell() {
        return ScoutSdkUi.getDefault().getShellImpl();
    }

    private Shell getShellImpl() {
        IWorkbenchWindow workbenchWindow = ScoutSdkUi.getWorkbenchWindow();
        if (workbenchWindow != null) {
            return workbenchWindow.getShell();
        }
        return null;
    }

    public static IScoutExplorerPart getExplorer(boolean createIfNotOpen) {
        return ScoutSdkUi.getDefault().getExplorerImpl(createIfNotOpen);
    }

    private IScoutExplorerPart getExplorerImpl(boolean createIfNotOpen) {
        IWorkbenchPage activePage = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IScoutExplorerPart part = null;
        if (activePage == null) {
            ScoutSdkUi.logWarning("no active part found.");
            return part;
        }
        IViewPart view = activePage.findView(IScoutConstants.SCOUT_EXPLORER_VIEW);
        if (view == null && createIfNotOpen) {
            try {
                view = activePage.showView(IScoutConstants.SCOUT_EXPLORER_VIEW);
                part = (IScoutExplorerPart)view;
            }
            catch (PartInitException e) {
                ScoutSdkUi.logWarning("could not open view '" + IScoutConstants.SCOUT_EXPLORER_VIEW + "'.", e);
            }
        } else {
            part = (IScoutExplorerPart)view;
        }
        return part;
    }

    public static ScoutSdkUi getDefault() {
        return plugin;
    }

    public static void log(IStatus log) {
        if (log instanceof LogStatus) {
            ScoutSdkUi.getDefault().logImpl((LogStatus)log);
        } else {
            ScoutSdkUi.getDefault().logImpl(new LogStatus(ScoutSdkUi.class, log.getSeverity(), log.getPlugin(), log.getMessage(), log.getException()));
        }
    }

    private void logImpl(LogStatus log) {
        if ((log.getSeverity() & this.m_loglevel) != 0) {
            this.getLog().log((IStatus)log);
        }
    }

    public static void logInfo(String message) {
        ScoutSdkUi.logInfo(message, null);
    }

    public static void logInfo(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        ScoutSdkUi.getDefault().logImpl(new LogStatus(ScoutSdkUi.class, 1, PLUGIN_ID, message, t));
    }

    public static void logWarning(String message) {
        ScoutSdkUi.logWarning(message, null);
    }

    public static void logWarning(Throwable t) {
        ScoutSdkUi.logWarning(null, t);
    }

    public static void logWarning(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        ScoutSdkUi.getDefault().logImpl(new LogStatus(ScoutSdkUi.class, 2, PLUGIN_ID, message, t));
    }

    public static void logError(Throwable t) {
        ScoutSdkUi.logError("", t);
    }

    public static void logError(String message) {
        ScoutSdkUi.logError(message, null);
    }

    public static void logError(String message, Throwable t) {
        if (message == null) {
            message = "";
        }
        ScoutSdkUi.getDefault().logImpl(new LogStatus(ScoutSdkUi.class, 4, PLUGIN_ID, message, t));
    }

    protected ColorRegistry createColorRegistry() {
        if (Display.getCurrent() != null) {
            return new ColorRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ColorRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public ColorRegistry getColorRegistry() {
        if (this.m_colorRegistry == null) {
            this.m_colorRegistry = this.createColorRegistry();
            this.initializeColorRegistry(this.m_colorRegistry);
        }
        return this.m_colorRegistry;
    }

    protected void initializeColorRegistry(ColorRegistry colorRegistry) {
        colorRegistry.put(COLOR_INACTIVE_FOREGROUND, new RGB(178, 178, 178));
    }

    public static Color getColor(String colorId) {
        return ScoutSdkUi.getDefault().getColorRegistry().get(colorId);
    }

    public FontRegistry getFontRegistry() {
        if (this.m_fontRegistry == null) {
            this.m_fontRegistry = new FontRegistry(ScoutSdkUi.getDisplay());
            FontData[] systemFontData = ScoutSdkUi.getDisplay().getSystemFont().getFontData();
            FontData[] systemBoldData = new FontData[systemFontData.length];
            int i = 0;
            while (i < systemFontData.length) {
                systemBoldData[i] = new FontData(systemFontData[i].getName(), systemFontData[i].getHeight(), 1);
                ++i;
            }
            this.m_fontRegistry.put(FONT_SYSTEM_BOLD, systemBoldData);
        }
        return this.m_fontRegistry;
    }

    public static Font getFont(String fontId) {
        return ScoutSdkUi.getDefault().getFontRegistry().get(fontId);
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    protected void initializeImageRegistry(org.eclipse.jface.resource.ImageRegistry reg) {
        reg.put("output_yes_disabled", ImageDescriptor.createWithFlags((ImageDescriptor)ScoutSdkUi.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"resources/icons/output_yes.gif"), (int)1));
        reg.put("output_no_disabled", ImageDescriptor.createWithFlags((ImageDescriptor)ScoutSdkUi.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"resources/icons/output_no.gif"), (int)1));
    }

    public ImageRegistry getImageRegistry() {
        return (ImageRegistry)super.getImageRegistry();
    }

    public static Image getImage(CompositeImageDescriptor imageDescriptor) {
        return ScoutSdkUi.getDefault().getImageImpl(imageDescriptor);
    }

    private Image getImageImpl(CompositeImageDescriptor imageDescriptor) {
        return this.getImageRegistry().get((ImageDescriptor)imageDescriptor);
    }

    public static Image getImage(String name) {
        return ScoutSdkUi.getDefault().getImageImpl(name);
    }

    private Image getImageImpl(String name) {
        Image image = this.getImageRegistry().get(name);
        if (image == null) {
            this.loadImage(name);
            image = this.getImageRegistry().get(name);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return ScoutSdkUi.getDefault().getImageDescriptorImpl(name);
    }

    private ImageDescriptor getImageDescriptorImpl(String name) {
        ImageDescriptor imageDesc = this.getImageRegistry().getDescriptor(name);
        if (imageDesc == null) {
            this.loadImage(name);
            imageDesc = this.getImageRegistry().getDescriptor(name);
        }
        return imageDesc;
    }

    private void loadImage(String name) {
        ImageDescriptor desc = null;
        desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name));
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".gif"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".png"));
        }
        if (desc == null) {
            desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)(IMAGE_PATH + name + ".jpg"));
        }
        if (desc == null) {
            ScoutSdkUi.logWarning("could not find image for plugin: 'org.eclipse.scout.sdk.ui' under: 'resources/icons/" + name + "'.");
        } else {
            this.getImageRegistry().put(name, desc);
        }
    }

    public static void showJavaElementInEditor(IJavaElement e, boolean createNew) {
        ScoutSdkUi.getDefault().showJavaElementInEditorImpl(e, createNew);
    }

    private void showJavaElementInEditorImpl(IJavaElement e, boolean createNew) {
        try {
            IEditorPart editor = null;
            if (createNew) {
                editor = JavaUI.openInEditor((IJavaElement)e);
            } else {
                editor = EditorUtility.isOpenInEditor((Object)e);
                if (editor != null) {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)editor);
                }
            }
            if (editor != null) {
                ITextEditor textEditor;
                IRegion reg;
                JavaUI.revealInEditor((IEditorPart)editor, (IJavaElement)e);
                if (editor instanceof ITextEditor && (reg = (textEditor = (ITextEditor)editor).getHighlightRange()) != null) {
                    textEditor.setHighlightRange(reg.getOffset(), reg.getLength(), true);
                }
            }
        }
        catch (Exception ex) {
            ScoutSdkUi.logWarning(ex);
        }
    }

    private int parseLogLevel(String loglevel) {
        int level = 15;
        if (!StringUtility.isNullOrEmpty((String)loglevel)) {
            String lowerLoglevel = loglevel.toLowerCase();
            if (lowerLoglevel.equals("warning")) {
                level = 14;
            } else if (lowerLoglevel.equals("error")) {
                level = 12;
            } else if (lowerLoglevel.equals("cancel")) {
                level = 8;
            }
        }
        return level;
    }

    private void contributeMenus(BundleContext context) {
        ServiceReference serviceReference = context.getServiceReference(IMenuService.class.getName());
        try {
            context.getService(serviceReference);
        }
        finally {
            context.ungetService(serviceReference);
        }
    }

    private class P_PreferenceStorePropertyListener
    implements IPropertyChangeListener {
        private P_PreferenceStorePropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.scout.sdk.propFormdataAutoUpdate".equals(event.getProperty())) {
                Boolean autoUpdate = (Boolean)event.getNewValue();
                ScoutSdk.getDefault().setFormDataAutoUpdate(autoUpdate.booleanValue());
            }
        }
    }
}

