/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ScoutStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.axis.AxisWebServiceClientSetupOperation;
import org.eclipse.scout.sdk.operation.axis.AxisWebServiceConsumerNewOperation;
import org.eclipse.scout.sdk.operation.axis.WsdlToJavaOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.AxisWebServiceConsumerDialog;
import org.eclipse.scout.sdk.ui.dialog.FileSelectionDialog;
import org.eclipse.scout.sdk.util.ApacheAxisUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;

public class AxisWebServiceConsumerNewAction
extends Action {
    private final IScoutBundle m_serverBundle;
    private String m_wsdlUrl;
    private final Shell m_parentShell;

    public AxisWebServiceConsumerNewAction(Shell parentShell, IScoutBundle serverBundle) {
        this.m_parentShell = parentShell;
        this.m_serverBundle = serverBundle;
        this.setText("New Webservice Consumer...");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serviceLocator_add.png"));
    }

    public void run() {
        AxisWebServiceConsumerDialog wsdlDialog = new AxisWebServiceConsumerDialog(this.m_parentShell);
        wsdlDialog.setWsdlUrl(this.getWsdlUrl());
        if (wsdlDialog.open() == 0) {
            String username = wsdlDialog.getUsername();
            this.setWsdlUrl(wsdlDialog.getWsdlUrl());
            String password = wsdlDialog.getPassword();
            try {
                AxisWebServiceClientSetupOperation setupOp = new AxisWebServiceClientSetupOperation(this.getServerBundle());
                OperationJob setupJob = new OperationJob((IOperation)setupOp);
                setupJob.schedule();
                setupJob.join();
                URL wsdlUrl = new URL(this.getWsdlUrl());
                File tmpDir = null;
                try {
                    tmpDir = File.createTempFile("wsdl2java", "");
                    tmpDir.delete();
                    tmpDir.mkdirs();
                    File sourceDir = new File(tmpDir, "src");
                    sourceDir.mkdirs();
                    WsdlToJavaOperation wsdlToJavaOp = new WsdlToJavaOperation();
                    wsdlToJavaOp.setWsdlUri(wsdlUrl.toURI());
                    wsdlToJavaOp.setProject(this.getServerBundle().getProject());
                    wsdlToJavaOp.setSourceDir(sourceDir);
                    wsdlToJavaOp.setUsername(username);
                    wsdlToJavaOp.setPassword(password);
                    OperationJob wsdlToJavaJob = new OperationJob((IOperation)wsdlToJavaOp);
                    wsdlToJavaJob.schedule();
                    wsdlToJavaJob.join();
                    ArrayList<IFile> inputList = new ArrayList<IFile>();
                    HashMap<IPath, File> pathToTmpFile = new HashMap<IPath, File>();
                    String deployPackagePath = null;
                    File[] fileArray = IOUtility.listFilesInSubtree((File)sourceDir, null);
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile ifile;
                        File f = fileArray[n2];
                        String pckName = ApacheAxisUtility.createPackageName((File)sourceDir, (File)f);
                        String pckPath = ApacheAxisUtility.createPackagePath((String)pckName);
                        if (f.getName().equalsIgnoreCase("deploy.wsdd")) {
                            deployPackagePath = pckPath;
                            ifile = this.getServerBundle().getProject().getFile("src/" + pckPath + "/" + f.getName());
                            inputList.add(ifile);
                            pathToTmpFile.put(ifile.getFullPath(), f);
                        } else if (f.getName().equalsIgnoreCase("undeploy.wsdd")) {
                            deployPackagePath = pckPath;
                            ifile = this.getServerBundle().getProject().getFile("src/" + pckPath + "/" + f.getName());
                            inputList.add(ifile);
                            pathToTmpFile.put(ifile.getFullPath(), f);
                        } else if (f.getName().endsWith(".java")) {
                            IType type;
                            if (pckName.startsWith(this.getServerBundle().getScoutProject().getProjectName())) {
                                ifile = this.getServerBundle().getProject().getFile("src/" + pckPath + "/" + f.getName());
                                inputList.add(ifile);
                                pathToTmpFile.put(ifile.getFullPath(), f);
                            } else if (!pckName.startsWith("com.bsiag.") && !TypeUtility.exists((IJavaElement)(type = ScoutSdk.getType((String)(String.valueOf(pckName) + "." + f.getName().substring(0, f.getName().length() - 5)))))) {
                                IFile ifile2 = this.getServerBundle().getProject().getFile("src/" + pckPath + "/" + f.getName());
                                inputList.add(ifile2);
                                pathToTmpFile.put(ifile2.getFullPath(), f);
                            }
                        }
                        ++n2;
                    }
                    if (deployPackagePath == null) {
                        throw new CoreException((IStatus)new ScoutStatus("Could not find neither a generated deploy.wsdd nor undeploy.wsdd"));
                    }
                    IFile deployFile = this.getServerBundle().getProject().getFile("src/" + deployPackagePath + "/deploy.wsdd");
                    IFile contentDescriptorFile = this.getServerBundle().getProject().getFile("src/" + deployPackagePath + "/client.properties");
                    FileSelectionDialog dialog = new FileSelectionDialog(this.m_parentShell, "Create Webservice Client", "Importing generated source files");
                    dialog.setFiles(inputList.toArray(new IFile[inputList.size()]));
                    dialog.setSelectedFiles(inputList.toArray(new IFile[inputList.size()]));
                    dialog.addPropertyChangeListener(new P_FileDialogPropertyListener(dialog));
                    if (dialog.open() == 0) {
                        IFile[] outputFiles = dialog.getSelectedFiles();
                        AxisWebServiceConsumerNewOperation newOp = new AxisWebServiceConsumerNewOperation();
                        newOp.setContentDescFile(contentDescriptorFile);
                        newOp.setDeployFile(deployFile);
                        newOp.setFiles(outputFiles);
                        newOp.setPathToTempDir(pathToTmpFile);
                        newOp.setServerProject(this.getServerBundle().getProject());
                        OperationJob newJob = new OperationJob((IOperation)newOp);
                        newJob.schedule();
                        newJob.join();
                    }
                }
                finally {
                    if (tmpDir != null) {
                        IOUtility.deleteDirectory((File)tmpDir);
                    }
                }
            }
            catch (Exception e) {
                ScoutSdkUi.logError(e);
            }
        }
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }

    public String getWsdlUrl() {
        return this.m_wsdlUrl;
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.m_wsdlUrl = wsdlUrl;
    }

    private class P_FileDialogPropertyListener
    implements PropertyChangeListener {
        private final FileSelectionDialog m_dialog;

        private P_FileDialogPropertyListener(FileSelectionDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedFiles")) {
                this.m_dialog.getOkButton().setEnabled(((IFile[])evt.getNewValue()).length > 0);
            }
        }
    }
}

