/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ScoutStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.axis.AxisWebServiceServerSetupOperation;
import org.eclipse.scout.sdk.operation.axis.JavaToWsdlOperation;
import org.eclipse.scout.sdk.operation.axis.WsdlToJavaOperation;
import org.eclipse.scout.sdk.pde.PdeUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.server.service.axis.util.FileListDialog;
import org.eclipse.scout.sdk.util.ApacheAxisUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;

public class AxisWebServiceProviderPublishAction
extends Action {
    private final Shell m_parentShell;
    private final IType m_implementationType;
    private final IType m_interfaceType;

    public AxisWebServiceProviderPublishAction(Shell parentShell, IType implementationType, IType interfaceType) {
        this.m_parentShell = parentShell;
        this.m_implementationType = implementationType;
        this.m_interfaceType = interfaceType;
        this.setText("Publish as WebService...");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("service_add.png"));
    }

    public void run() {
        try {
            IScoutBundle implementationScoutBundle = ScoutSdk.getScoutWorkspace().getScoutBundle(this.getImplementationType().getJavaProject().getProject());
            AxisWebServiceServerSetupOperation setupOp = new AxisWebServiceServerSetupOperation(implementationScoutBundle);
            OperationJob setupJob = new OperationJob((IOperation)setupOp);
            setupJob.schedule();
            try {
                setupJob.join();
            }
            catch (InterruptedException e) {
                ScoutSdkUi.logWarning("interrupted by waiting for setting up the web service publish operation.", e);
            }
            IProject project = implementationScoutBundle.getProject();
            String packageName = this.getImplementationType().getPackageFragment().getElementName();
            String serviceName = this.getImplementationType().getElementName();
            File tmpDir = null;
            try {
                tmpDir = File.createTempFile("wsdl2java", "");
                tmpDir.delete();
                tmpDir.mkdirs();
                File wsdlFile = new File(tmpDir, String.valueOf(serviceName) + ".wsdl");
                wsdlFile.deleteOnExit();
                File sourceDir = new File(tmpDir, "src");
                sourceDir.mkdirs();
                String publishWsdlUrl = "http://localhost:8080/bsicrm/services/" + serviceName.toLowerCase();
                JavaToWsdlOperation java2wsdlOp = new JavaToWsdlOperation();
                java2wsdlOp.setNamespace("http://" + ApacheAxisUtility.reversePackageName((String)packageName));
                java2wsdlOp.setProject(project);
                java2wsdlOp.setPublishUrl(publishWsdlUrl);
                java2wsdlOp.setServiceClassname(String.valueOf(packageName) + "." + serviceName);
                java2wsdlOp.setWsdlAbsolutePath(wsdlFile.getAbsolutePath());
                OperationJob java2wsdlJob = new OperationJob((IOperation)java2wsdlOp);
                java2wsdlJob.schedule();
                try {
                    java2wsdlJob.join();
                }
                catch (InterruptedException e) {
                    ScoutSdkUi.logWarning("java to wsdl interrupted.", e);
                }
                WsdlToJavaOperation wsdl2java = new WsdlToJavaOperation();
                wsdl2java.setImplClassQName(this.getImplementationType().getFullyQualifiedName());
                wsdl2java.setProject(project);
                wsdl2java.setSourceDir(sourceDir);
                wsdl2java.setWsdlUri(wsdlFile.toURI());
                OperationJob wsdl2JavaJob = new OperationJob((IOperation)wsdl2java);
                wsdl2JavaJob.schedule();
                try {
                    wsdl2JavaJob.join();
                }
                catch (InterruptedException e) {
                    ScoutSdkUi.logWarning("wsdl to java interrupted.", e);
                }
                ArrayList<IFile> inputList = new ArrayList<IFile>();
                HashMap<IPath, File> pathToTmpFile = new HashMap<IPath, File>();
                String deployPackagePath = null;
                File[] fileArray = IOUtility.listFilesInSubtree((File)sourceDir, null);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type;
                    IFile ifile;
                    File f = fileArray[n2];
                    String pckName = ApacheAxisUtility.createPackageName((File)sourceDir, (File)f);
                    String pckPath = ApacheAxisUtility.createPackagePath((String)pckName);
                    if (f.getName().equalsIgnoreCase("deploy.wsdd")) {
                        deployPackagePath = pckPath;
                        ifile = project.getFile("src/" + pckPath + "/" + serviceName + "-deploy.wsdd");
                        inputList.add(ifile);
                        pathToTmpFile.put(ifile.getFullPath(), f);
                    } else if (f.getName().equalsIgnoreCase("undeploy.wsdd")) {
                        deployPackagePath = pckPath;
                        ifile = project.getFile("src/" + pckPath + "/" + serviceName + "-undeploy.wsdd");
                        inputList.add(ifile);
                        pathToTmpFile.put(ifile.getFullPath(), f);
                    } else if (f.getName().endsWith(".java") && !pckName.startsWith(implementationScoutBundle.getScoutProject().getProjectName()) && !pckName.startsWith("com.bsiag.") && !TypeUtility.exists((IJavaElement)(type = ScoutSdk.getType((String)(String.valueOf(pckName) + "." + f.getName().substring(0, f.getName().length() - 5)))))) {
                        IFile ifile2 = project.getFile("src/" + pckPath + "/" + f.getName());
                        inputList.add(ifile2);
                        pathToTmpFile.put(ifile2.getFullPath(), f);
                    }
                    ++n2;
                }
                if (deployPackagePath == null) {
                    throw new CoreException((IStatus)new ScoutStatus("Could not find neither a generated deploy.wsdd nor undeploy.wsdd"));
                }
                IFile deployFile = project.getFile("src/" + deployPackagePath + "/" + serviceName + "-deploy.wsdd");
                IFile contentDescriptorFile = project.getFile("src/" + deployPackagePath + "/" + serviceName + "-server.properties");
                List<IFile> outputList = FileListDialog.showThreadSafe("Publish Webservice", "Importing generated source files", "The following source files will be added (if checked) to the project " + project.getName() + ". Existing files are being overwritten. Please review this list.", inputList);
                if (outputList == null) {
                    throw new CoreException((IStatus)new ScoutStatus("Publishing cancelled", (Throwable)new InterruptedException()));
                }
                StringBuilder buf = new StringBuilder();
                int fileIndex = 0;
                for (IFile ifile : outputList) {
                    if (!ifile.getName().endsWith(".java")) continue;
                    IPath path = ifile.getFullPath();
                    path = path.removeFirstSegments(path.matchingFirstSegments(project.getFullPath()));
                    buf.append("file" + fileIndex + "=" + path.toString() + "\n");
                    ++fileIndex;
                }
                PdeUtility.createFile((IFile)contentDescriptorFile, (InputStream)new ByteArrayInputStream(buf.toString().getBytes()), (IProgressMonitor)new NullProgressMonitor());
                for (IFile ifile : outputList) {
                    File tmpFile = (File)pathToTmpFile.get(ifile.getFullPath());
                    FileInputStream in = new FileInputStream(tmpFile);
                    try {
                        PdeUtility.createFile((IFile)ifile, (InputStream)in, (IProgressMonitor)new NullProgressMonitor());
                    }
                    finally {
                        in.close();
                    }
                }
                PdeUtility.addBuildPropertiesFiles((IProject)project, (String)"bin.includes", (String[])new String[]{"server-config.wsdd"});
                ApacheAxisUtility.runDeploy((File)deployFile.getLocation().toFile(), (String)"server", (IProject)project, (IProgressMonitor)new NullProgressMonitor());
            }
            finally {
                project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                if (tmpDir != null) {
                    IOUtility.deleteDirectory((File)tmpDir);
                }
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logError(e);
        }
    }

    public IType getImplementationType() {
        return this.m_implementationType;
    }

    public IType getInterfaceType() {
        return this.m_interfaceType;
    }
}

