/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.template.CreateTemplateOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.TemplateFromFromFieldDialog;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.swt.widgets.Shell;

public class CreateTemplateAction
extends Action {
    private final IType m_type;
    private TemplateFromFromFieldDialog m_dialog;
    private final Shell m_shell;
    private IScoutBundle m_bundle;
    private String m_packageName;
    private final IPage m_page;

    public CreateTemplateAction(Shell shell, IPage page, IType type) {
        super("Create template...");
        this.m_shell = shell;
        this.m_page = page;
        this.m_type = type;
        this.m_bundle = SdkTypeUtility.getScoutBundle((IJavaElement)this.m_type);
        this.m_packageName = this.m_bundle.getPackageName(".ui.template.formfield");
    }

    public void run() {
        String name = "Abstract" + this.getType().getElementName();
        this.m_dialog = new TemplateFromFromFieldDialog(this.getShell(), name, this.getType());
        if (this.m_dialog.open() == 0) {
            CreateTemplateOperation op = new CreateTemplateOperation(this.getType());
            op.setTemplateName(this.m_dialog.getTemplateName());
            op.setPackageName(this.m_packageName);
            op.setTemplateBundle(this.m_bundle);
            op.setReplaceFieldWithTemplate(this.m_dialog.isReplaceFormField());
            op.setCreateExternalFormData(this.m_dialog.isCreateExternalFormData());
            op.validate();
            OperationJob job = new OperationJob((IOperation)op);
            job.schedule();
            try {
                job.join();
                this.m_page.markStructureDirty();
            }
            catch (InterruptedException e) {
                ScoutSdkUi.logWarning("could not wait for job '" + job.getName() + "'.", e);
            }
        }
    }

    public Shell getShell() {
        return this.m_shell;
    }

    public IType getType() {
        return this.m_type;
    }
}

