/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.sdk.NamingUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ScoutStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.axis.AxisWebServiceConsumerDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.FileSelectionDialog;
import org.eclipse.scout.sdk.util.ApacheAxisUtility;
import org.eclipse.swt.widgets.Shell;

public class AxisWebServiceConsumerDeleteAction
extends Action {
    private IType m_serviceLocator;
    private final Shell m_parentShell;

    public AxisWebServiceConsumerDeleteAction(Shell parentShell) {
        this.m_parentShell = parentShell;
        this.setText("Delete...");
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("serviceLocator_remove.png"));
    }

    public void run() {
        try {
            IFile[] outputFiles;
            String deployPackagePath = ApacheAxisUtility.createPackagePath((String)this.getServiceLocator().getPackageFragment().getElementName());
            IProject serverProject = this.getServiceLocator().getJavaProject().getProject();
            IFile deployFile = serverProject.getFile("src/" + deployPackagePath + "/deploy.wsdd");
            IFile undeployFile = serverProject.getFile("src/" + deployPackagePath + "/undeploy.wsdd");
            IFile contentDescriptorFile = serverProject.getFile("src/" + deployPackagePath + "/client.properties");
            ArrayList<IFile> inputList = new ArrayList<IFile>();
            if (contentDescriptorFile.exists()) {
                String[] lines;
                inputList.add(contentDescriptorFile);
                try {
                    lines = new String(IOUtility.getContent((InputStream)contentDescriptorFile.getContents(true))).split("[\\n\\r]+");
                }
                catch (ProcessingException e) {
                    throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
                }
                Pattern pat = Pattern.compile("file[0-9]+=(.*)");
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    Matcher m = pat.matcher(line = line.trim());
                    if (m.matches()) {
                        IFile ifile = serverProject.getFile(m.group(1));
                        if (ifile.exists()) {
                            inputList.add(ifile);
                        } else if (ifile.getName().endsWith(".java")) {
                            IType[] iTypeArray = ScoutSdk.resolveTypes((String)NamingUtility.removeSuffixes((String)ifile.getName(), (String[])new String[]{".java"}));
                            int n3 = iTypeArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IType type = iTypeArray[n4];
                                IResource res = type.getCompilationUnit().getResource();
                                if (res != null && res.getType() == 1 && serverProject.exists(res.getProjectRelativePath())) {
                                    inputList.add((IFile)res);
                                }
                                ++n4;
                            }
                        }
                    }
                    ++n2;
                }
            }
            if (deployFile.exists()) {
                inputList.add(deployFile);
            }
            FileSelectionDialog dialog = new FileSelectionDialog(this.m_parentShell, "Remove Webservice Client", "Deleting the following source files");
            dialog.setFiles(inputList.toArray(new IFile[inputList.size()]));
            dialog.setSelectedFiles(inputList.toArray(new IFile[inputList.size()]));
            dialog.addPropertyChangeListener(new P_FileDialogPropertyListener(dialog));
            if (dialog.open() == 0 && (outputFiles = dialog.getSelectedFiles()).length > 0) {
                AxisWebServiceConsumerDeleteOperation delOp = new AxisWebServiceConsumerDeleteOperation();
                delOp.setFiles(outputFiles);
                delOp.setUndeployFile(undeployFile);
                delOp.setServerProject(this.getServiceLocator().getJavaProject().getProject());
                new OperationJob((IOperation)delOp).schedule();
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("Error during executing '" + AxisWebServiceConsumerDeleteAction.class.getName() + "'.", e);
        }
    }

    public void setServiceLocator(IType serviceLocator) {
        this.m_serviceLocator = serviceLocator;
    }

    public IType getServiceLocator() {
        return this.m_serviceLocator;
    }

    private class P_FileDialogPropertyListener
    implements PropertyChangeListener {
        private final FileSelectionDialog m_dialog;

        private P_FileDialogPropertyListener(FileSelectionDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedFiles")) {
                this.m_dialog.getOkButton().setEnabled(((IFile[])evt.getNewValue()).length > 0);
            }
        }
    }
}

