/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.sdk.NamingUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ScoutStatus;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.axis.WebServiceUndeployOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.FileSelectionDialog;
import org.eclipse.scout.sdk.util.ApacheAxisUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.DeleteResourcesOperation;

public class AxisWebServiceUndeployAction
extends Action {
    private final Shell m_parentShell;
    private final IScoutBundle m_serverBundle;
    private final IType m_implementationType;

    public AxisWebServiceUndeployAction(Shell parentShell, String text, IScoutBundle serverBundle, IType implementationType) {
        this.m_parentShell = parentShell;
        this.m_serverBundle = serverBundle;
        this.m_implementationType = implementationType;
        this.setText(text);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("service_remove.png"));
    }

    public void run() {
        block20: {
            try {
                IFile[] outputFiles;
                IProject project = this.getServerBundle().getProject();
                String packageName = this.getImplementationType().getPackageFragment().getElementName();
                String serviceName = this.getImplementationType().getElementName();
                String deployPackagePath = ApacheAxisUtility.createPackagePath((String)packageName);
                IFile deployFile = project.getFile("src/" + deployPackagePath + "/" + serviceName + "-deploy.wsdd");
                IFile undeployFile = project.getFile("src/" + deployPackagePath + "/" + serviceName + "-undeploy.wsdd");
                IFile contentDescriptorFile = project.getFile("src/" + deployPackagePath + "/" + serviceName + "-server.properties");
                ArrayList<IFile> inputList = new ArrayList<IFile>();
                if (contentDescriptorFile.exists()) {
                    String[] lines;
                    inputList.add(contentDescriptorFile);
                    try {
                        lines = new String(IOUtility.getContent((InputStream)contentDescriptorFile.getContents(true))).split("[\\n\\r]+");
                    }
                    catch (ProcessingException e) {
                        throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
                    }
                    Pattern pat = Pattern.compile("file[0-9]+=(.*)");
                    String[] stringArray = lines;
                    int n = lines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        Matcher m = pat.matcher(line = line.trim());
                        if (m.matches()) {
                            IFile ifile = project.getFile(m.group(1));
                            if (ifile.exists()) {
                                inputList.add(ifile);
                            } else if (ifile.getName().endsWith(".java")) {
                                IType[] iTypeArray = ScoutSdk.resolveTypes((String)NamingUtility.removeSuffixes((String)ifile.getName(), (String[])new String[]{".java"}));
                                int n3 = iTypeArray.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    IType bctype = iTypeArray[n4];
                                    IResource res = bctype.getCompilationUnit().getResource();
                                    if (res != null && res.getType() == 1 && project.exists(res.getProjectRelativePath())) {
                                        inputList.add((IFile)res);
                                    }
                                    ++n4;
                                }
                            }
                        }
                        ++n2;
                    }
                }
                if (deployFile.exists()) {
                    inputList.add(deployFile);
                }
                if (undeployFile.exists()) {
                    inputList.add(undeployFile);
                }
                FileSelectionDialog dialog = new FileSelectionDialog(this.m_parentShell, "Remove Webservice Client", "Deleting the following source files");
                dialog.setFiles(inputList.toArray(new IFile[inputList.size()]));
                dialog.setSelectedFiles(inputList.toArray(new IFile[inputList.size()]));
                dialog.addPropertyChangeListener(new P_FileDialogPropertyListener(dialog));
                if (dialog.open() != 0) break block20;
                if (undeployFile != null && undeployFile.exists()) {
                    WebServiceUndeployOperation undeployOp = new WebServiceUndeployOperation();
                    undeployOp.setProject(this.getServerBundle().getProject());
                    undeployOp.setRole("server");
                    undeployOp.setUndeployFile(undeployFile);
                    OperationJob undeployJob = new OperationJob((IOperation)undeployOp);
                    undeployJob.schedule();
                    try {
                        undeployJob.join();
                    }
                    catch (InterruptedException e) {
                        ScoutSdkUi.logWarning("could not wait for undeploy '" + undeployFile.getFullPath() + "' job.", e);
                    }
                }
                if ((outputFiles = dialog.getSelectedFiles()).length > 0) {
                    P_ResourceDeleteOperation deleteFilesOp = new P_ResourceDeleteOperation(outputFiles);
                    OperationJob deleteFilesJob = new OperationJob((IOperation)deleteFilesOp);
                    deleteFilesJob.schedule();
                    try {
                        deleteFilesJob.join();
                    }
                    catch (InterruptedException e) {
                        ScoutSdkUi.logWarning("could not wait for files delete job.", e);
                    }
                }
            }
            catch (Exception e) {
                ScoutSdkUi.logError("web service undeploy failed.", e);
            }
        }
    }

    public IScoutBundle getServerBundle() {
        return this.m_serverBundle;
    }

    public IType getImplementationType() {
        return this.m_implementationType;
    }

    private class P_FileDialogPropertyListener
    implements PropertyChangeListener {
        private final FileSelectionDialog m_dialog;

        private P_FileDialogPropertyListener(FileSelectionDialog dialog) {
            this.m_dialog = dialog;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("selectedFiles")) {
                this.m_dialog.getOkButton().setEnabled(((IFile[])evt.getNewValue()).length > 0);
            }
        }
    }

    private class P_ResourceDeleteOperation
    implements IOperation {
        private final IFile[] m_files;

        public P_ResourceDeleteOperation(IFile[] files) {
            this.m_files = files;
        }

        public String getOperationName() {
            return "Delete resources... ";
        }

        public void run(IProgressMonitor monitor, IScoutWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
            try {
                try {
                    new DeleteResourcesOperation((IResource[])this.m_files, "Delete wsdl Files...", true).execute(monitor, null);
                }
                catch (ExecutionException e) {
                    ScoutSdkUi.logError("Could not delete wsdl files.", e);
                    AxisWebServiceUndeployAction.this.getServerBundle().getProject().refreshLocal(1, monitor);
                }
            }
            finally {
                AxisWebServiceUndeployAction.this.getServerBundle().getProject().refreshLocal(1, monitor);
            }
        }

        public void validate() throws IllegalArgumentException {
        }
    }
}

