/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.form.field.BoxDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.util.ScoutSourceUtilities;
import org.eclipse.swt.widgets.Shell;

public class BoxDeleteAction
extends Action {
    private Shell m_shell;
    private MemberSelectionDialog m_confirmDialog;
    private final IType m_boxType;

    public BoxDeleteAction(IType boxType, Shell shell) {
        super(Texts.get((String)"Process_deleteX", (String[])new String[]{ScoutSourceUtilities.getTranslatedMethodStringValue((IType)boxType, (String)"getConfiguredLabel")}));
        this.m_boxType = boxType;
        this.m_shell = shell;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("groupbox_remove.png"));
    }

    public void run() {
        this.m_confirmDialog = new MemberSelectionDialog(this.m_shell, this.getText());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            BoxDeleteOperation op = new BoxDeleteOperation(this.getBoxType());
            OperationJob job = new OperationJob((IOperation)op);
            job.schedule();
        }
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        members.add((IMember)this.getBoxType());
        selectedMembers.add((IMember)this.getBoxType());
    }

    public IType getBoxType() {
        return this.m_boxType;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            BoxDeleteAction.this.m_confirmDialog.setMessage("");
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            }
            BoxDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

