/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.widgets.Shell;

public class FormDeleteAction
extends Action {
    private IType m_formType;
    private IType m_formData;
    private IType m_processServiceInterface;
    private IType m_processServiceImplementation;
    private final Shell m_shell;
    private MemberSelectionDialog m_confirmDialog;

    public FormDeleteAction(IType formType, Shell shell) {
        super(Texts.get((String)"Action_deleteTypeX", (String[])new String[]{formType.getElementName()}));
        this.m_shell = shell;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("form_remove.png"));
        this.m_formType = formType;
    }

    public void run() {
        this.m_confirmDialog = new MemberSelectionDialog(this.m_shell, Texts.get((String)"Action_deleteTypeX", (String[])new String[]{this.getFormType().getElementName()}));
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation(){

                protected void deleteMember(IJavaElement member, Set<ICompilationUnit> icuForOrganizeImports, IProgressMonitor monitor, IScoutWorkingCopyManager manager) throws CoreException {
                    if (FormDeleteAction.this.m_processServiceInterface != null && member.equals(FormDeleteAction.this.m_processServiceInterface)) {
                        ScoutUtility.unregisterServiceClass((IProject)FormDeleteAction.this.m_processServiceInterface.getJavaProject().getProject(), (String)"org.eclipse.scout.rt.client.serviceProxies", (String)"serviceProxy", (String)FormDeleteAction.this.m_processServiceInterface.getFullyQualifiedName(), null, (IProgressMonitor)monitor);
                    }
                    if (FormDeleteAction.this.m_processServiceImplementation != null && member.equals(FormDeleteAction.this.m_processServiceImplementation)) {
                        IScoutBundle implementationBundle = ScoutSdk.getScoutWorkspace().getScoutBundle(FormDeleteAction.this.m_processServiceImplementation.getJavaProject().getProject());
                        ScoutUtility.unregisterServiceClass((IProject)FormDeleteAction.this.m_processServiceImplementation.getJavaProject().getProject(), (String)"org.eclipse.scout.rt.server.services", (String)"service", (String)FormDeleteAction.this.m_processServiceImplementation.getFullyQualifiedName(), (String)(String.valueOf(implementationBundle.getRootPackageName()) + ".ServerSession"), (IProgressMonitor)monitor);
                    }
                    super.deleteMember(member, icuForOrganizeImports, monitor, manager);
                }
            };
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob((IOperation)op);
            job.schedule();
        }
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        IType[] iTypeArray;
        ITypeFilter serviceFilter;
        String serviceName;
        int n;
        members.add((IMember)this.m_formType);
        selectedMembers.add((IMember)this.m_formType);
        if (this.m_formData == null) {
            IType abstractFormData = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData");
            IPrimaryTypeTypeHierarchy formDataHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)abstractFormData);
            ITypeFilter formDataFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getFormType().getJavaProject()), TypeFilters.getClassFilter()});
            IType[] iTypeArray2 = formDataHierarchy.getAllSubtypes(abstractFormData, formDataFilter, null);
            n = iTypeArray2.length;
            int n2 = 0;
            while (n2 < n) {
                IType candidate = iTypeArray2[n2];
                if (candidate.getElementName().equals(String.valueOf(this.getFormType().getElementName()) + "Data")) {
                    this.m_formData = candidate;
                    break;
                }
                ++n2;
            }
        }
        if (this.m_formData != null && this.m_formData.exists()) {
            members.add((IMember)this.m_formData);
            selectedMembers.add((IMember)this.m_formData);
        }
        IType iService = ScoutSdk.getType((String)"org.eclipse.scout.service.IService");
        IPrimaryTypeTypeHierarchy serviceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)iService);
        if (this.m_processServiceInterface == null) {
            serviceName = this.getFormType().getElementName().replaceAll("^(.*)Form$", "I$1ProcessService");
            serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getFormType().getJavaProject()), TypeFilters.getInterfaceFilter()});
            iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            int n3 = iTypeArray.length;
            n = 0;
            while (n < n3) {
                IType candidate = iTypeArray[n];
                if (candidate.getElementName().equals(serviceName)) {
                    this.m_processServiceInterface = candidate;
                    break;
                }
                ++n;
            }
        }
        if (this.m_processServiceInterface != null && this.m_processServiceImplementation == null) {
            serviceName = this.getFormType().getElementName().replaceAll("^(.*)Form$", "$1ProcessService");
            serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getInScoutProject((IScoutProject)ScoutSdk.getScoutWorkspace().getScoutBundle(this.getFormType().getJavaProject().getProject()).getScoutProject()), TypeFilters.getClassFilter()});
            iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            int n4 = iTypeArray.length;
            n = 0;
            while (n < n4) {
                IType candidate = iTypeArray[n];
                if (candidate.getElementName().equals(serviceName)) {
                    this.m_processServiceImplementation = candidate;
                    break;
                }
                ++n;
            }
        }
        if (this.m_processServiceInterface != null) {
            members.add((IMember)this.m_processServiceInterface);
        }
        if (this.m_processServiceImplementation != null) {
            members.add((IMember)this.m_processServiceImplementation);
        }
        String permissionRegex = this.getFormType().getElementName().replaceAll("^(.*)Form$", "(Create|Read|Update)$1Permission");
        IType permission = ScoutSdk.getType((String)Permission.class.getName());
        IPrimaryTypeTypeHierarchy permissionHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)permission);
        ITypeFilter permissionFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getFormType().getJavaProject()), TypeFilters.getClassFilter()});
        IType[] iTypeArray3 = permissionHierarchy.getAllSubtypes(permission, permissionFilter, null);
        int n5 = iTypeArray3.length;
        int n6 = 0;
        while (n6 < n5) {
            IType candidate = iTypeArray3[n6];
            if (candidate.getElementName().matches(permissionRegex)) {
                members.add((IMember)candidate);
            }
            ++n6;
        }
    }

    public IType getFormType() {
        return this.m_formType;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            FormDeleteAction.this.m_confirmDialog.setMessage("");
            HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(selection));
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            }
            if (FormDeleteAction.this.m_processServiceImplementation != null && FormDeleteAction.this.m_processServiceInterface != null && members.contains(FormDeleteAction.this.m_processServiceInterface) != members.contains(FormDeleteAction.this.m_processServiceImplementation)) {
                FormDeleteAction.this.m_confirmDialog.setMessage("Process service interface and implementation must have the same selection.", 3);
                canOk = false;
            }
            if (FormDeleteAction.this.m_formType != null && FormDeleteAction.this.m_formData != null && members.contains(FormDeleteAction.this.m_formType) != members.contains(FormDeleteAction.this.m_formData)) {
                FormDeleteAction.this.m_confirmDialog.setMessage("FormData '" + FormDeleteAction.this.m_formData.getElementName() + "' should be deleted together with the form.", 2);
            }
            FormDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

