/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.typecache.IScoutWorkingCopyManager;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.swt.widgets.Shell;

public class LookupCallDeleteAction
extends Action {
    private IType m_lookupCall;
    private IType m_lookupService;
    private IType m_lookupServiceInterface;
    private final Shell m_shell;
    private MemberSelectionDialog m_confirmDialog;

    public LookupCallDeleteAction(IType lookupCall, Shell shell) {
        super("Delete Lookup Call");
        this.m_shell = shell;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("lookupCall_remove.png"));
        this.m_lookupCall = lookupCall;
    }

    public void run() {
        this.m_confirmDialog = new MemberSelectionDialog(this.m_shell, "Delete Lookup Call");
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation(){

                protected void deleteMember(IJavaElement member, Set<ICompilationUnit> icuForOrganizeImports, IProgressMonitor monitor, IScoutWorkingCopyManager manager) throws CoreException {
                    if (LookupCallDeleteAction.this.m_lookupServiceInterface != null && member.equals(LookupCallDeleteAction.this.m_lookupServiceInterface)) {
                        ScoutUtility.unregisterServiceClass((IProject)LookupCallDeleteAction.this.m_lookupServiceInterface.getJavaProject().getProject(), (String)"org.eclipse.scout.rt.client.serviceProxies", (String)"serviceProxy", (String)LookupCallDeleteAction.this.m_lookupServiceInterface.getFullyQualifiedName(), null, (IProgressMonitor)monitor);
                    }
                    if (LookupCallDeleteAction.this.m_lookupService != null && member.equals(LookupCallDeleteAction.this.m_lookupService)) {
                        IScoutBundle implementationBundle = ScoutSdk.getScoutWorkspace().getScoutBundle(LookupCallDeleteAction.this.m_lookupService.getJavaProject().getProject());
                        ScoutUtility.unregisterServiceClass((IProject)LookupCallDeleteAction.this.m_lookupService.getJavaProject().getProject(), (String)"org.eclipse.scout.rt.server.services", (String)"service", (String)LookupCallDeleteAction.this.m_lookupService.getFullyQualifiedName(), (String)(String.valueOf(implementationBundle.getRootPackageName()) + ".ServerSession"), (IProgressMonitor)monitor);
                    }
                    super.deleteMember(member, icuForOrganizeImports, monitor, manager);
                }
            };
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob((IOperation)op);
            job.schedule();
        }
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        IType candidate;
        int n;
        int n2;
        IType[] iTypeArray;
        ITypeFilter serviceFilter;
        String serviceName;
        members.add((IMember)this.getLookupCall());
        selectedMembers.add((IMember)this.getLookupCall());
        IType iService = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.services.lookup.ILookupService");
        IPrimaryTypeTypeHierarchy serviceHierarchy = ScoutSdk.getPrimaryTypeHierarchy((IType)iService);
        if (this.m_lookupServiceInterface == null) {
            serviceName = this.getLookupCall().getElementName().replaceAll("^(.*)LookupCall$", "I$1LookupService");
            serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getTypesOnClasspath((IJavaProject)this.getLookupCall().getJavaProject()), TypeFilters.getInterfaceFilter()});
            iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            n2 = iTypeArray.length;
            n = 0;
            while (n < n2) {
                candidate = iTypeArray[n];
                if (candidate.getElementName().equals(serviceName)) {
                    this.m_lookupServiceInterface = candidate;
                    break;
                }
                ++n;
            }
        }
        if (this.m_lookupServiceInterface != null && this.m_lookupService == null) {
            serviceName = this.getLookupCall().getElementName().replaceAll("^(.*)LookupCall$", "$1LookupService");
            serviceFilter = TypeFilters.getMultiTypeFilter((ITypeFilter[])new ITypeFilter[]{TypeFilters.getInScoutProject((IScoutProject)ScoutSdk.getScoutWorkspace().getScoutBundle(this.getLookupCall().getJavaProject().getProject()).getScoutProject()), TypeFilters.getClassFilter()});
            iTypeArray = serviceHierarchy.getAllSubtypes(iService, serviceFilter, null);
            n2 = iTypeArray.length;
            n = 0;
            while (n < n2) {
                candidate = iTypeArray[n];
                if (candidate.getElementName().equals(serviceName)) {
                    this.m_lookupService = candidate;
                    break;
                }
                ++n;
            }
        }
        if (this.m_lookupServiceInterface != null) {
            members.add((IMember)this.m_lookupServiceInterface);
        }
        if (this.m_lookupService != null) {
            members.add((IMember)this.m_lookupService);
        }
    }

    public IType getLookupCall() {
        return this.m_lookupCall;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            LookupCallDeleteAction.this.m_confirmDialog.setMessage("");
            HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(selection));
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            }
            if (LookupCallDeleteAction.this.m_lookupService != null && LookupCallDeleteAction.this.m_lookupServiceInterface != null && members.contains(LookupCallDeleteAction.this.m_lookupServiceInterface) != members.contains(LookupCallDeleteAction.this.m_lookupService)) {
                LookupCallDeleteAction.this.m_confirmDialog.setMessage("Process service interface and implementation must have the same selection.", 3);
                canOk = false;
            }
            LookupCallDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

