/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.swt.widgets.Shell;

public class MemberListDeleteAction
extends Action {
    private final Shell m_shell;
    private IMember[] m_typesToDelete = new IMember[0];
    private MemberSelectionDialog m_confirmDialog;

    public MemberListDeleteAction(String title, Shell shell) {
        super(title);
        this.m_shell = shell;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("remove.png"));
    }

    public void run() {
        this.m_confirmDialog = new MemberSelectionDialog(this.m_shell, this.getText());
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation();
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob((IOperation)op);
            job.schedule();
        }
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        if (this.getTypesToDelete() != null) {
            IMember[] iMemberArray = this.getTypesToDelete();
            int n = iMemberArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMember t = iMemberArray[n2];
                members.add(t);
                selectedMembers.add(t);
                ++n2;
            }
        }
    }

    public boolean addMemberToDelete(IMember type) {
        HashSet<IMember> types = new HashSet<IMember>(Arrays.asList(this.getTypesToDelete()));
        boolean added = types.add(type);
        this.setTypesToDelete(types.toArray(new IMember[types.size()]));
        return added;
    }

    public boolean removeTypeToDelete(IMember type) {
        HashSet<IMember> types = new HashSet<IMember>(Arrays.asList(this.getTypesToDelete()));
        boolean removed = types.remove(type);
        this.setTypesToDelete(types.toArray(new IMember[types.size()]));
        return removed;
    }

    public void setTypesToDelete(IMember[] typesToDelete) {
        this.m_typesToDelete = typesToDelete;
    }

    public IMember[] getTypesToDelete() {
        return this.m_typesToDelete;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            MemberListDeleteAction.this.m_confirmDialog.setMessage("");
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            }
            MemberListDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

