/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.workspace.member.IPropertyBean;
import org.eclipse.swt.widgets.Shell;

public class PropertyBeanDeleteAction
extends Action {
    private final Shell m_shell;
    private MemberSelectionDialog m_confirmDialog;
    private final IPropertyBean m_beanDesc;

    public PropertyBeanDeleteAction(String title, Shell shell, IPropertyBean beanDesc) {
        super(title);
        this.m_beanDesc = beanDesc;
        this.m_shell = shell;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("variable_remove.png"));
    }

    public void run() {
        this.m_confirmDialog = new MemberSelectionDialog(this.m_shell, this.getText());
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        ArrayList<IMember> members = new ArrayList<IMember>();
        ArrayList<IMember> selectedMembers = new ArrayList<IMember>();
        this.collectAffectedMembers(members, selectedMembers);
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(selectedMembers.toArray(new IMember[selectedMembers.size()]));
        if (this.m_confirmDialog.open() == 0) {
            JavaElementDeleteOperation op = new JavaElementDeleteOperation();
            op.setMembers((IJavaElement[])this.m_confirmDialog.getSelectedMembers());
            OperationJob job = new OperationJob((IOperation)op);
            job.schedule();
        }
    }

    protected void collectAffectedMembers(List<IMember> members, List<IMember> selectedMembers) {
        IMember[] beanMembers = this.getBeanDesc().getAllMembers();
        members.addAll(Arrays.asList(beanMembers));
        selectedMembers.addAll(Arrays.asList(beanMembers));
    }

    public IPropertyBean getBeanDesc() {
        return this.m_beanDesc;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            PropertyBeanDeleteAction.this.m_confirmDialog.setMessage("");
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            } else {
                HashSet<IMember> members = new HashSet<IMember>(Arrays.asList(selection));
                if (members.contains(PropertyBeanDeleteAction.this.getBeanDesc().getField()) && (PropertyBeanDeleteAction.this.getBeanDesc().getReadMethod() != null && !members.contains(PropertyBeanDeleteAction.this.getBeanDesc().getReadMethod()) || PropertyBeanDeleteAction.this.getBeanDesc().getWriteMethod() != null && !members.contains(PropertyBeanDeleteAction.this.getBeanDesc().getWriteMethod()))) {
                    canOk = false;
                    PropertyBeanDeleteAction.this.m_confirmDialog.setMessage("The field can only be deleted together with the read and write method.", 3);
                }
            }
            PropertyBeanDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

