/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import java.util.ArrayList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.service.ServiceDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.IMemberSelectionChangedListener;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;

public class ServiceDeleteAction
extends Action {
    private MemberSelectionDialog m_confirmDialog;
    private final Shell m_shell;
    private final IType m_serviceImplementation;
    private IType m_serviceInterface;

    public ServiceDeleteAction(Shell shell, IType serviceInterface, IType serviceImplementation) {
        this.m_shell = shell;
        this.m_serviceInterface = serviceInterface;
        this.m_serviceImplementation = serviceImplementation;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("service_remove.png"));
        this.setText("Delete...");
    }

    public void run() {
        this.m_confirmDialog = new MemberSelectionDialog(this.m_shell, this.getText());
        ArrayList<IType> members = new ArrayList<IType>();
        if (TypeUtility.exists((IJavaElement)this.m_serviceInterface)) {
            members.add(this.m_serviceInterface);
        }
        if (TypeUtility.exists((IJavaElement)this.m_serviceImplementation)) {
            members.add(this.m_serviceImplementation);
        }
        this.m_confirmDialog.setMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.setSelectedMembers(members.toArray(new IMember[members.size()]));
        this.m_confirmDialog.addMemberSelectionListener(new P_SelectionValidationListener());
        if (this.m_confirmDialog.open() == 0) {
            ServiceDeleteOperation deleteOp = new ServiceDeleteOperation();
            IMember[] iMemberArray = this.m_confirmDialog.getSelectedMembers();
            int n = iMemberArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMember m = iMemberArray[n2];
                String qallifiedName = ((IType)m).getFullyQualifiedName();
                if (this.m_serviceInterface != null && this.m_serviceInterface.getFullyQualifiedName().equals(qallifiedName)) {
                    deleteOp.setServiceInterface(this.m_serviceInterface);
                } else if (this.m_serviceImplementation.getFullyQualifiedName().equals(qallifiedName)) {
                    deleteOp.setServiceImplementation(this.m_serviceImplementation);
                }
                ++n2;
            }
            OperationJob job = new OperationJob((IOperation)deleteOp);
            job.schedule();
        }
    }

    public IType getServiceImplementation() {
        return this.m_serviceImplementation;
    }

    private class P_SelectionValidationListener
    implements IMemberSelectionChangedListener {
        private P_SelectionValidationListener() {
        }

        @Override
        public void handleSelectionChanged(IMember[] selection) {
            ServiceDeleteAction.this.m_confirmDialog.setMessage("");
            boolean canOk = true;
            if (selection == null || selection.length == 0) {
                canOk = false;
            }
            ServiceDeleteAction.this.m_confirmDialog.getOkButton().setEnabled(canOk);
        }
    }
}

