/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.delete;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.util.JavaElementDeleteOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.MemberSelectionDialog;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class TableColumnDeleteAction
extends Action {
    private Shell m_shell;
    private MemberSelectionDialog m_confirmDialog;
    private final IType m_tableColumn;

    public TableColumnDeleteAction(IType tableColumn, Shell shell) {
        super("Delete...");
        this.m_tableColumn = tableColumn;
        this.m_shell = shell;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("tableColumn_remove.png"));
    }

    public void run() {
        MessageBox box = new MessageBox(this.m_shell, 292);
        box.setMessage("Are you sure you want to delete '" + this.getTableColumn().getElementName() + "'?");
        if (box.open() == 32) {
            JavaElementDeleteOperation delOp = new JavaElementDeleteOperation();
            delOp.addMember((IJavaElement)this.getTableColumn());
            IMethod getter = SdkTypeUtility.getColumnGetterMethod((IType)this.getTableColumn());
            if (TypeUtility.exists((IJavaElement)getter)) {
                delOp.addMember((IJavaElement)getter);
            }
            OperationJob job = new OperationJob((IOperation)delOp);
            job.schedule();
        }
    }

    public IType getTableColumn() {
        return this.m_tableColumn;
    }
}

