/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.dnd;

import java.util.HashSet;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.dnd.FormFieldDndOperation;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.RenameConfirmationDialog;
import org.eclipse.swt.widgets.Shell;

public class FormFieldRelocateAction
extends Action {
    private boolean createCopy;
    private int m_location;
    private IType m_formField;
    private IType m_targetDeclaringType;
    private IType m_neighborField;
    private String m_newFieldName;
    private final Shell m_shell;

    public FormFieldRelocateAction(IType formFieldToMove, Shell shell) {
        super("Relocate Form Field");
        this.m_formField = formFieldToMove;
        this.m_shell = shell;
    }

    public void run() {
        String fieldName = this.getFormField().getElementName();
        HashSet<String> usedNames = new HashSet<String>();
        try {
            IType[] iTypeArray = this.m_targetDeclaringType.getCompilationUnit().getAllTypes();
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType t = iTypeArray[n2];
                usedNames.add(t.getElementName());
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("During finding used names.", e);
        }
        if (this.getFormField().getCompilationUnit().equals(this.getTargetDeclaringType().getCompilationUnit()) && !this.isCreateCopy()) {
            usedNames.remove(this.getFormField().getElementName());
        }
        if (usedNames.contains(this.getFormField().getElementName())) {
            String message = "Enter a name of the " + (this.isCreateCopy() ? "copied" : "moved") + " form field.";
            RenameConfirmationDialog dialog = new RenameConfirmationDialog(this.m_shell, "Form Field Name", message);
            dialog.setNotAllowedNames(usedNames);
            dialog.setTypeName("CopyOf" + this.getFormField().getElementName());
            if (dialog.open() != 0) {
                return;
            }
            fieldName = dialog.getTypeName();
        }
        int mode = 2;
        if (this.isCreateCopy()) {
            mode = 1;
        }
        FormFieldDndOperation dndOp = new FormFieldDndOperation(this.getFormField(), this.getTargetDeclaringType(), fieldName, mode);
        dndOp.setPosition(this.getLocation());
        dndOp.setPositionType(this.getNeighborField());
        new OperationJob((IOperation)dndOp).schedule();
    }

    public void setFormField(IType formField) {
        this.m_formField = formField;
    }

    public IType getFormField() {
        return this.m_formField;
    }

    public void setTargetDeclaringType(IType targetDeclaringType) {
        this.m_targetDeclaringType = targetDeclaringType;
    }

    public IType getTargetDeclaringType() {
        return this.m_targetDeclaringType;
    }

    public void setNeighborField(IType neighborField) {
        this.m_neighborField = neighborField;
    }

    public IType getNeighborField() {
        return this.m_neighborField;
    }

    public void setCreateCopy(boolean createCopy) {
        this.createCopy = createCopy;
    }

    public boolean isCreateCopy() {
        return this.createCopy;
    }

    public void setLocation(int location) {
        this.m_location = location;
    }

    public int getLocation() {
        return this.m_location;
    }
}

