/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.RenameDialog;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractRenameAction
extends Action {
    private RenameDialog m_dialog;
    private final String m_readOnlySuffix;
    private String m_oldName;
    private final Shell m_shell;

    public AbstractRenameAction(Shell shell, String name, String oldName, String readOnlySuffix) {
        super(name);
        this.m_shell = shell;
        this.setOldName(oldName);
        this.m_readOnlySuffix = readOnlySuffix;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("rename.gif"));
    }

    public void run() {
        this.m_dialog = new RenameDialog(this.m_shell, "Rename...", this.getOldName(), this.getReadOnlySuffix());
        this.m_dialog.addPropertyChangeListener(new P_PropertyListener());
        this.getDialog().create();
        this.validateInternal(this.getDialog().getNewName());
        if (this.getDialog().open() == 0) {
            try {
                JdtRenameTransaction tx = new JdtRenameTransaction();
                this.fillTransaction(tx, this.getDialog().getNewName());
                tx.commit(ScoutSdkUi.getShell());
            }
            catch (CoreException e) {
                ScoutSdkUi.logError("rename failed.", e);
            }
        }
    }

    protected abstract void fillTransaction(JdtRenameTransaction var1, String var2) throws CoreException;

    public RenameDialog getDialog() {
        return this.m_dialog;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    private void validateInternal(String newName) {
        IStatus status = this.validate(newName);
        this.getDialog().getOkButton().setEnabled(true);
        switch (status.getSeverity()) {
            case 4: {
                this.getDialog().setMessage(status.getMessage(), 3);
                this.getDialog().getOkButton().setEnabled(false);
                break;
            }
            case 2: {
                this.getDialog().setMessage(status.getMessage(), 2);
                break;
            }
            case 1: {
                this.getDialog().setMessage(status.getMessage(), 1);
                break;
            }
            default: {
                this.getDialog().setMessage("", 0);
            }
        }
    }

    protected abstract IStatus validate(String var1);

    protected IStatus getJavaNameStatus(String newName) {
        if (newName.equals(this.getReadOnlySuffix())) {
            return new Status(4, "org.eclipse.scout.sdk", "Name can not be null or empty");
        }
        if (newName.matches("\\b[A-Z][a-zA-Z0-9_]{0,200}\\b")) {
            return Status.OK_STATUS;
        }
        if (newName.matches("\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b")) {
            return new Status(2, "org.eclipse.scout.sdk", Texts.get((String)"Warning_notWellformedJavaName"));
        }
        return Status.OK_STATUS;
    }

    public void setOldName(String oldName) {
        this.m_oldName = oldName;
    }

    public String getOldName() {
        return this.m_oldName;
    }

    private class P_PropertyListener
    implements PropertyChangeListener {
        private P_PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("newName")) {
                AbstractRenameAction.this.validateInternal((String)evt.getNewValue());
            }
        }
    }
}

