/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.util.ScoutSourceUtilities;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;

public class FormFieldRenameAction
extends AbstractRenameAction {
    private final IType m_formField;

    public FormFieldRenameAction(Shell shell, String name, IType formField, String readOnlySuffix) {
        super(shell, name, formField.getElementName(), readOnlySuffix);
        this.m_formField = formField;
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getFormField(), newName);
        IMethod getter = SdkTypeUtility.getFormFieldGetterMethod((IType)this.getFormField());
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + Character.toUpperCase(newName.charAt(0)) + newName.substring(1));
        }
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        try {
            if (ScoutSourceUtilities.findInnerType((IType)this.getFormField().getCompilationUnit().getAllTypes()[0], (String)newName, (boolean)true) != null) {
                return new Status(4, "org.eclipse.scout.sdk", "Name already in use.");
            }
        }
        catch (CoreException e) {
            ScoutSdkUi.logError("error during finding already existing types in form.", e);
            return new Status(4, "org.eclipse.scout.sdk", "Exception in validation (see logfile).");
        }
        return inheritedStatus;
    }

    public IType getFormField() {
        return this.m_formField;
    }
}

