/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.swt.widgets.Shell;

public class ServiceRenameAction
extends AbstractRenameAction {
    private final IType m_serviceInterface;
    private final IType m_serviceImplementation;

    public ServiceRenameAction(Shell shell, String name, IType serviceImplementation, IType serviceInterface, String readOnlySuffix) {
        super(shell, name, serviceImplementation.getElementName(), readOnlySuffix);
        this.m_serviceImplementation = serviceImplementation;
        this.m_serviceInterface = serviceInterface;
    }

    @Override
    protected IStatus validate(String newName) {
        String packName;
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (this.m_serviceImplementation != null && ScoutSdk.existsType((String)(String.valueOf(packName = this.m_serviceImplementation.getPackageFragment().getElementName()) + "." + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        if (this.m_serviceInterface != null && ScoutSdk.existsType((String)(String.valueOf(packName = this.m_serviceInterface.getPackageFragment().getElementName()) + ".I" + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        return inheritedStatus;
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.m_serviceImplementation, newName);
        if (this.m_serviceInterface != null) {
            transaction.add(this.m_serviceInterface, "I" + newName);
        }
    }

    @Override
    public void run() {
        super.run();
    }
}

