/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.swt.widgets.Shell;

public class TypeRenameAction
extends AbstractRenameAction {
    private final IType m_type;

    public TypeRenameAction(Shell shell, String name, IType type, String readOnlySuffix) {
        super(shell, name, type.getElementName(), readOnlySuffix);
        this.m_type = type;
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getType(), newName);
    }

    @Override
    protected IStatus validate(String newName) {
        String packName;
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        IType declaringType = this.getType().getDeclaringType();
        if (declaringType != null ? declaringType.getType(newName) != null : ScoutSdk.existsType((String)(String.valueOf(packName = this.getType().getPackageFragment().getElementName()) + "." + newName))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", "Name already in use.");
        }
        return inheritedStatus;
    }

    public IType getType() {
        return this.m_type;
    }
}

