/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.action.rename;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.rename.AbstractRenameAction;
import org.eclipse.scout.sdk.ui.internal.jdt.JdtRenameTransaction;
import org.eclipse.scout.sdk.workspace.type.SdkTypeUtility;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.widgets.Shell;

public class WizardStepRenameAction
extends AbstractRenameAction {
    private final IType m_wizardStep;

    public WizardStepRenameAction(Shell shell, String name, IType wizardStep) {
        super(shell, name, wizardStep.getElementName(), "Step");
        this.m_wizardStep = wizardStep;
    }

    @Override
    protected void fillTransaction(JdtRenameTransaction transaction, String newName) throws CoreException {
        transaction.add(this.getWizardStep(), newName);
        IMethod getter = SdkTypeUtility.getWizardStepGetterMethod((IType)this.getWizardStep());
        if (TypeUtility.exists((IJavaElement)getter)) {
            transaction.add(getter, "get" + Character.toUpperCase(newName.charAt(0)) + newName.substring(1));
        }
    }

    @Override
    protected IStatus validate(String newName) {
        IStatus inheritedStatus = this.getJavaNameStatus(newName);
        if (inheritedStatus.matches(4)) {
            return inheritedStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.getWizardStep().getDeclaringType().getType(newName))) {
            return new Status(4, "org.eclipse.scout.sdk", "Name already in use.");
        }
        return inheritedStatus;
    }

    public IType getWizardStep() {
        return this.m_wizardStep;
    }
}

