/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.dialog.AbstractStatusDialog;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AxisWebServiceConsumerDialog
extends AbstractStatusDialog {
    private StyledTextField m_wsdlUrlField;
    private StyledTextField m_usernameField;
    private StyledTextField m_passwordField;
    private String m_wsdlUrl;
    private String m_username;
    private String m_password;

    public AxisWebServiceConsumerDialog(Shell parentShell) {
        super(parentShell);
        this.setTitle("New Webservice Consumer");
        this.setMessage("Create a new Webservice consumer.");
        this.setTitleImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_NEW_WIZARD"));
    }

    protected Control createDialogArea(Composite originalParent) {
        Composite parent = new Composite(originalParent, 0);
        this.m_wsdlUrlField = this.getFieldToolkit().createStyledTextField(parent, "WSDL URL");
        this.m_wsdlUrlField.setText(this.getWsdlUrl());
        this.m_wsdlUrlField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AxisWebServiceConsumerDialog.this.m_wsdlUrl = AxisWebServiceConsumerDialog.this.m_wsdlUrlField.getText();
                AxisWebServiceConsumerDialog.this.pingStateChanging();
            }
        });
        this.m_usernameField = this.getFieldToolkit().createStyledTextField(parent, "Username");
        this.m_usernameField.setText(this.getWsdlUrl());
        this.m_usernameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AxisWebServiceConsumerDialog.this.setUsername(AxisWebServiceConsumerDialog.this.m_usernameField.getText());
                AxisWebServiceConsumerDialog.this.pingStateChanging();
            }
        });
        this.m_passwordField = this.getFieldToolkit().createStyledTextField(parent, "Password");
        this.m_passwordField.setText(this.getWsdlUrl());
        this.m_passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AxisWebServiceConsumerDialog.this.setPassword(AxisWebServiceConsumerDialog.this.m_passwordField.getText());
                AxisWebServiceConsumerDialog.this.pingStateChanging();
            }
        });
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_wsdlUrlField.setLayoutData(new GridData(768));
        this.m_usernameField.setLayoutData(new GridData(768));
        this.m_passwordField.setLayoutData(new GridData(768));
        return parent;
    }

    @Override
    protected void validate(MultiStatus multiStatus) {
        super.validate(multiStatus);
        if (StringUtility.isNullOrEmpty((String)this.getWsdlUrl())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", "WSDL URL can not be empty."));
        } else {
            multiStatus.add(Status.OK_STATUS);
        }
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.m_wsdlUrl = wsdlUrl;
    }

    public String getWsdlUrl() {
        return this.m_wsdlUrl;
    }

    public void setUsername(String username) {
        this.m_username = username;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getPassword() {
        return this.m_password;
    }
}

