/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.table.AutoResizeColumnTable;
import org.eclipse.scout.sdk.ui.fields.table.FileTableContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class FileSelectionDialog
extends TitleAreaDialog {
    public static final String PROP_SELECTED_FILES = "selectedFiles";
    private BasicPropertySupport m_propertySupport;
    private IFile[] m_files;
    private CheckboxTableViewer m_viewer;
    private final String m_title;
    private String m_message;

    public FileSelectionDialog(Shell parentShell, String title, String message) {
        this(parentShell, title);
        this.m_message = message;
    }

    public FileSelectionDialog(Shell parentShell, String title) {
        super(parentShell);
        this.m_title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_propertySupport.setProperty(PROP_SELECTED_FILES, (Object)new IFile[0]);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_title != null) {
            newShell.setText(this.m_title);
        }
    }

    public IFile[] getFiles() {
        return this.m_files;
    }

    public void setFiles(IFile[] files) {
        this.m_files = files;
        if (this.getContents() != null) {
            this.getContentProvider().setElements(files);
            this.m_viewer.refresh();
        }
    }

    public IFile[] getSelectedFiles() {
        return (IFile[])this.m_propertySupport.getProperty(PROP_SELECTED_FILES);
    }

    public void setSelectedFiles(IFile[] selectedFiles) {
        this.m_propertySupport.setProperty(PROP_SELECTED_FILES, (Object)selectedFiles);
        if (this.getContents() != null) {
            this.m_viewer.setCheckedElements((Object[])selectedFiles);
        }
    }

    private void setSelectedFilesFromUI(IFile[] selectedFiles) {
        this.m_propertySupport.setProperty(PROP_SELECTED_FILES, (Object)selectedFiles);
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    protected Control createDialogArea(Composite parent) {
        if (this.m_message != null) {
            this.setMessage(this.m_message);
        }
        Composite rootPane = new Composite(parent, 0);
        AutoResizeColumnTable table = new AutoResizeColumnTable(rootPane, 67616);
        TableColumn simpleNameCol = new TableColumn((Table)table, 16384);
        simpleNameCol.setData("columnWeight", (Object)new Integer(3));
        simpleNameCol.setWidth(170);
        simpleNameCol.setText("File");
        TableColumn packageCol = new TableColumn((Table)table, 16384);
        packageCol.setData("columnWeight", (Object)new Integer(5));
        packageCol.setText("Path");
        packageCol.setWidth(270);
        this.m_viewer = new CheckboxTableViewer((Table)table);
        this.m_viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object[] checkedElements = FileSelectionDialog.this.m_viewer.getCheckedElements();
                FileSelectionDialog.this.setSelectedFilesFromUI((IFile[])TypeCastUtility.castValue((Object)checkedElements, IFile[].class));
            }
        });
        FileTableContentProvider provider = new FileTableContentProvider();
        provider.setElements(this.getFiles());
        this.m_viewer.setContentProvider((IContentProvider)provider);
        this.m_viewer.setLabelProvider((IBaseLabelProvider)provider);
        this.m_viewer.setInput((Object)provider);
        this.m_viewer.setCheckedElements((Object[])this.getSelectedFiles());
        if (parent.getLayout() instanceof GridLayout) {
            rootPane.setLayoutData((Object)new GridData(1808));
        }
        rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_viewer.getTable().setLayoutData((Object)new GridData(1808));
        return rootPane;
    }

    private FileTableContentProvider getContentProvider() {
        return (FileTableContentProvider)this.m_viewer.getContentProvider();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }
}

