/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.beans.PropertyChangeListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.fields.table.JavaElementTableContentProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class JavaElementSelectionDialog
extends Dialog {
    public static final String PROP_SELECTED_ELEMENTS = "selectedElements";
    private BasicPropertySupport m_propertySupport;
    private FilteredTable m_filteredTable;
    private IJavaElement[] m_javaElements;
    private final String m_title;
    private Point m_initialLocation;
    private boolean m_multiSelect = false;

    public JavaElementSelectionDialog(Shell parentShell, String title) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_title = title;
        this.m_propertySupport = new BasicPropertySupport((Object)this);
        this.m_propertySupport.setProperty(PROP_SELECTED_ELEMENTS, (Object)new IJavaElement[0]);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.m_title);
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.m_initialLocation != null) {
            return this.m_initialLocation;
        }
        return super.getInitialLocation(initialSize);
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootArea = new Composite(parent, 0);
        int style = (this.isMultiSelect() ? 2 : 4) | 0x800 | 0x10000 | 0x200;
        this.m_filteredTable = new FilteredTable(rootArea, style);
        this.m_filteredTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                IJavaElement[] selectedElements = (IJavaElement[])TypeCastUtility.castValue((Object)selection.toArray(), IJavaElement[].class);
                JavaElementSelectionDialog.this.m_propertySupport.setProperty(JavaElementSelectionDialog.PROP_SELECTED_ELEMENTS, (Object)selectedElements);
            }
        });
        TableColumn simpleNameCol = new TableColumn(this.m_filteredTable.getTable(), 16384);
        simpleNameCol.setData("columnWeight", (Object)new Integer(3));
        simpleNameCol.setWidth(170);
        simpleNameCol.setText("Member");
        TableColumn packageCol = new TableColumn(this.m_filteredTable.getTable(), 16384);
        packageCol.setData("columnWeight", (Object)new Integer(5));
        packageCol.setText("Package");
        packageCol.setWidth(270);
        JavaElementTableContentProvider provider = new JavaElementTableContentProvider();
        provider.setElements(this.getJavaElements());
        this.m_filteredTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_filteredTable.getViewer().setContentProvider((IContentProvider)provider);
        this.m_filteredTable.getViewer().setInput((Object)provider);
        rootArea.setLayout((Layout)new FillLayout());
        rootArea.setLayoutData((Object)new GridData(1808));
        return rootArea;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    public void setJavaElements(IJavaElement[] javaElements) {
        if (this.getContents() != null) {
            throw new IllegalStateException("control already created.");
        }
        this.m_javaElements = javaElements;
    }

    public IJavaElement[] getJavaElements() {
        return this.m_javaElements;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.m_multiSelect = multiSelect;
    }

    public boolean isMultiSelect() {
        return this.m_multiSelect;
    }

    public IJavaElement[] getSelectedElements() {
        return (IJavaElement[])this.m_propertySupport.getProperty(PROP_SELECTED_ELEMENTS);
    }

    public void setInitialLocation(Point initialLocation) {
        this.m_initialLocation = initialLocation;
    }

    public Point getInitialLocation() {
        return this.m_initialLocation;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(propertyName, listener);
    }
}

