/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.wizard.WizardPageFieldToolkit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RenameDialog
extends TitleAreaDialog {
    public static final String PROP_NEW_NAME = "newName";
    private final WizardPageFieldToolkit m_fieldToolkit;
    private final String m_title;
    private final String m_oldName;
    private final String m_readOnlySuffix;
    private final String m_readOnlyPrefix;
    private BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);
    private StyledTextField m_typeNameField;

    public RenameDialog(Shell parentShell, String title, String oldName, String readOnlySuffix) {
        this(parentShell, title, oldName, readOnlySuffix, null);
    }

    public RenameDialog(Shell parentShell, String title, String oldName, String readOnlySuffix, String readOnlyPrefix) {
        super(parentShell);
        this.m_title = title;
        this.m_oldName = oldName;
        this.setNewName(this.m_oldName);
        this.m_readOnlySuffix = readOnlySuffix;
        this.m_readOnlyPrefix = readOnlyPrefix;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.m_fieldToolkit = new WizardPageFieldToolkit();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_title != null) {
            newShell.setText(this.m_title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootPane = new Composite(parent, 0);
        this.m_typeNameField = this.m_fieldToolkit.createStyledTextField(rootPane, "Name");
        this.m_typeNameField.setReadOnlySuffix(this.getReadOnlySuffix());
        this.m_typeNameField.setReadOnlyPrefix(this.getReadOnlyPrefix());
        this.m_typeNameField.setText(this.getNewName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RenameDialog.this.m_propertySupport.setPropertyString(RenameDialog.PROP_NEW_NAME, RenameDialog.this.m_typeNameField.getText());
            }
        });
        rootPane.setLayoutData((Object)new GridData(1808));
        rootPane.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        return rootPane;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    public String getOldName() {
        return this.m_oldName;
    }

    public String getReadOnlySuffix() {
        return this.m_readOnlySuffix;
    }

    public String getReadOnlyPrefix() {
        return this.m_readOnlyPrefix;
    }

    public void setNewName(String newName) {
        if (this.getContents() != null && !this.getContents().isDisposed()) {
            this.m_typeNameField.setText(newName);
        }
        this.m_propertySupport.setPropertyString(PROP_NEW_NAME, newName);
    }

    public String getNewName() {
        return this.m_propertySupport.getPropertyString(PROP_NEW_NAME);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }
}

