/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.dialog;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IWizardPageContainer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class WizardPageDialog
extends TitleAreaDialog
implements IWizardPageContainer {
    private final AbstractWorkspaceWizardPage m_page;

    public WizardPageDialog(Shell shell, AbstractWorkspaceWizardPage page) {
        super(shell);
        this.m_page = page;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.m_page != null) {
            newShell.setText(this.m_page.getTitle());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite rootPane = new Composite(parent, 0);
        rootPane.setLayout((Layout)new FillLayout());
        this.m_page.createControl(parent);
        return rootPane;
    }

    public Button getOkButton() {
        return this.getButton(0);
    }

    @Override
    public void setStatus(IStatus status, IStatus defaultOkStatus) {
        int messagetype;
        this.getOkButton().setEnabled(true);
        IStatus highestSeverityStatus = this.getHighestSeverityStatus(status, defaultOkStatus);
        switch (highestSeverityStatus.getSeverity()) {
            case 1: {
                messagetype = 1;
                break;
            }
            case 2: {
                messagetype = 2;
                break;
            }
            case 4: {
                this.getOkButton().setEnabled(false);
                messagetype = 3;
                break;
            }
            default: {
                messagetype = 0;
            }
        }
        String message = highestSeverityStatus.getMessage();
        this.setMessage(message, messagetype);
    }

    private IStatus getHighestSeverityStatus(IStatus status, IStatus highestSeverity) {
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                highestSeverity = this.getHighestSeverityStatus(child, highestSeverity);
                ++n2;
            }
            return highestSeverity;
        }
        if (highestSeverity.getSeverity() < status.getSeverity()) {
            highestSeverity = status;
        }
        return highestSeverity;
    }
}

