/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import java.io.File;
import java.util.EventListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.IFileSelectionListener;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class FileSelectionField
extends TextField {
    private Button m_popupButton;
    private File m_file;
    private EventListenerList m_eventListeners;
    private OptimisticLock m_inputLock = new OptimisticLock();
    private String[] m_filterExtensions;
    private String m_fileName;

    public FileSelectionField(Composite parent) {
        super(parent);
        this.m_eventListeners = new EventListenerList();
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        Label label = this.getLabelComponent();
        StyledText text = this.getTextComponent();
        this.m_popupButton = new Button(parent, 8);
        this.m_popupButton.setImage(ScoutSdkUi.getImage("file.gif"));
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionField.this.showFileChooserDialog();
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                block6: {
                    try {
                        try {
                            if (!FileSelectionField.this.m_inputLock.acquire()) break block6;
                            String input = FileSelectionField.this.getText();
                            File newFile = new File(input);
                            if (newFile.getParentFile() != null && newFile.getParentFile().exists()) {
                                FileSelectionField.this.setFileInternal(newFile);
                                break block6;
                            }
                            FileSelectionField.this.setFileInternal(null);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            FileSelectionField.this.m_inputLock.release();
                        }
                    }
                    finally {
                        FileSelectionField.this.m_inputLock.release();
                    }
                }
            }
        });
        parent.setTabList(new Control[]{text});
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(40, 0);
        labelData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 5);
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        textData.bottom = new FormAttachment(100, 0);
        text.setLayoutData((Object)textData);
        FormData buttonData = new FormData(22, 22);
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    private void showFileChooserDialog() {
        FileDialog dialog = new FileDialog(this.getShell());
        if (this.getFileName() != null) {
            dialog.setFileName(this.getFileName());
        }
        dialog.setOverwrite(true);
        if (this.getFilterExtensions() != null) {
            dialog.setFilterExtensions(this.getFilterExtensions());
        }
        String fileName = dialog.open();
        File newFile = null;
        if (!StringUtility.isNullOrEmpty((String)fileName)) {
            if (this.getFilterExtensions() != null && this.getFilterExtensions().length > 0) {
                int extIndex = dialog.getFilterIndex();
                Matcher m = Pattern.compile("\\.([^\\.]*)$").matcher(fileName);
                String extension = null;
                if (m.find()) {
                    String[] stringArray = this.getFilterExtensions();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fExt = stringArray[n2];
                        if (StringUtility.equalsIgnoreCase((String)fExt, (String)("*." + m.group(1)))) {
                            extension = m.group(1);
                            break;
                        }
                        ++n2;
                    }
                }
                if (extension == null && extIndex > -1 && extIndex < this.getFilterExtensions().length) {
                    extension = this.getFilterExtensions()[extIndex];
                    extension = extension.replaceFirst("\\**", "");
                    fileName = String.valueOf(fileName) + extension;
                }
            }
            newFile = new File(fileName);
            try {
                if (this.m_inputLock.acquire()) {
                    this.getTextComponent().setText(newFile.getAbsolutePath());
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
        this.setFileInternal(newFile);
    }

    public void addProductSelectionListener(IFileSelectionListener listener) {
        this.m_eventListeners.add(IFileSelectionListener.class, (EventListener)listener);
    }

    public void removeProductSelectionListener(IFileSelectionListener listener) {
        this.m_eventListeners.remove(IFileSelectionListener.class, (EventListener)listener);
    }

    private void fireFileSelected(File file) {
        IFileSelectionListener[] iFileSelectionListenerArray = (IFileSelectionListener[])this.m_eventListeners.getListeners(IFileSelectionListener.class);
        int n = iFileSelectionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFileSelectionListener l = iFileSelectionListenerArray[n2];
            l.fileSelected(file);
            ++n2;
        }
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFilterExtensions(String[] filterExtensions) {
        this.m_filterExtensions = filterExtensions;
    }

    public String[] getFilterExtensions() {
        return this.m_filterExtensions;
    }

    public File getFile() {
        return this.m_file;
    }

    public void setFile(File file) {
        this.m_file = file;
        if (!this.isDisposed()) {
            String text = "";
            if (file != null) {
                text = file.getAbsolutePath();
            }
            try {
                if (this.m_inputLock.acquire()) {
                    this.getTextComponent().setText(text);
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
    }

    public void setFileInternal(File file) {
        if (!CompareUtility.equals((Object)this.getFile(), (Object)file)) {
            this.setFile(file);
            this.fireFileSelected(file);
        }
    }
}

