/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.dialog.CheckableTreeSelectionDialog;
import org.eclipse.scout.sdk.ui.fields.IFolderSelectedListener;
import org.eclipse.scout.sdk.ui.fields.ResourceServletFolderTree;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.workspace.IScoutProject;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ResourceServletFolderSelectionField
extends TextField {
    private Button m_popupButton;
    private IFolder m_folder;
    private EventListenerList m_eventListeners;
    private OptimisticLock m_inputLock = new OptimisticLock();
    private final IScoutProject m_scoutProject;
    private ITreeNode m_rootNode;

    public ResourceServletFolderSelectionField(Composite parent, IScoutProject scoutProject) {
        super(parent);
        this.m_scoutProject = scoutProject;
        this.m_eventListeners = new EventListenerList();
        this.m_rootNode = new ResourceServletFolderTree(scoutProject).getRootNode();
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        Label label = this.getLabelComponent();
        StyledText text = this.getTextComponent();
        this.m_popupButton = new Button(parent, 8);
        this.m_popupButton.setImage(ScoutSdkUi.getImage("down.gif"));
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceServletFolderSelectionField.this.showFolderChooser();
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    if (ResourceServletFolderSelectionField.this.m_inputLock.acquire()) {
                        IFolder folder;
                        String input = ResourceServletFolderSelectionField.this.getText();
                        Path p = new Path(input);
                        if (p.segmentCount() > 1 && (folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)p)).exists() && TreeUtility.findNode(ResourceServletFolderSelectionField.this.getRootNode(), NodeFilters.getByData(folder)) != null) {
                            ResourceServletFolderSelectionField.this.setFolderInternal(folder);
                            return;
                        }
                        ResourceServletFolderSelectionField.this.setFolderInternal(null);
                    }
                }
                finally {
                    ResourceServletFolderSelectionField.this.m_inputLock.release();
                }
            }
        });
        parent.setTabList(new Control[]{text});
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(40, 0);
        labelData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 5);
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        textData.bottom = new FormAttachment(100, 0);
        text.setLayoutData((Object)textData);
        FormData buttonData = new FormData(22, 22);
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    private void showFolderChooser() {
        CheckableTreeSelectionDialog dialog = new CheckableTreeSelectionDialog(this.getShell(), this.m_rootNode);
        dialog.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("checkedNodes".equals(evt.getPropertyName())) {
                    ITreeNode selNode = (ITreeNode)evt.getNewValue();
                    ((CheckableTreeSelectionDialog)((Object)evt.getSource())).setComplete(selNode.getType() == ResourceServletFolderTree.NODE_TYPE_FOLDER);
                }
            }
        });
        if (dialog.open() == 0) {
            ITreeNode selectedNode = dialog.getSelectedNode();
            String text = "";
            IFolder selectedFolder = null;
            if (selectedNode.getType() == ResourceServletFolderTree.NODE_TYPE_FOLDER) {
                selectedFolder = (IFolder)selectedNode.getData();
                text = String.valueOf(selectedFolder.getProject().getName()) + "/" + selectedFolder.getProjectRelativePath();
            }
            this.setFolderInternal(selectedFolder);
            try {
                this.m_inputLock.acquire();
                this.getTextComponent().setText(text);
            }
            finally {
                this.m_inputLock.release();
            }
        }
    }

    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    public void addProductSelectionListener(IFolderSelectedListener listener) {
        this.m_eventListeners.add(IFolderSelectedListener.class, (EventListener)listener);
    }

    public void removeProductSelectionListener(IFolderSelectedListener listener) {
        this.m_eventListeners.remove(IFolderSelectedListener.class, (EventListener)listener);
    }

    private void fireProductSelected(IFolder folder) {
        IFolderSelectedListener[] iFolderSelectedListenerArray = (IFolderSelectedListener[])this.m_eventListeners.getListeners(IFolderSelectedListener.class);
        int n = iFolderSelectedListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFolderSelectedListener l = iFolderSelectedListenerArray[n2];
            l.handleFolderSelection(folder);
            ++n2;
        }
    }

    public void setFolder(IFolder folder) {
        this.m_folder = folder;
        if (!this.isDisposed()) {
            try {
                if (this.m_inputLock.acquire()) {
                    String text = "";
                    if (folder != null) {
                        text = String.valueOf(folder.getProject().getName()) + "/" + folder.getProjectRelativePath();
                    }
                    this.getTextComponent().setText(text);
                }
            }
            finally {
                this.m_inputLock.release();
            }
        }
    }

    private void setFolderInternal(IFolder folder) {
        if (!CompareUtility.equals((Object)this.m_folder, (Object)folder)) {
            this.setFolder(folder);
            this.fireProductSelected(folder);
        }
    }

    public IFolder getFolder() {
        return this.m_folder;
    }
}

