/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.bundletree;

import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;

public final class NodeFilters {
    private NodeFilters() {
    }

    public static ITreeNodeFilter getByData(final Object ... data) {
        return new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                if (data == null) {
                    return node.getData() == null;
                }
                Object[] objectArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o.equals(node.getData())) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
    }

    public static ITreeNodeFilter getByType(final int type) {
        return new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                return type == node.getType();
            }
        };
    }

    public static ITreeNodeFilter getByLabel(final String label) {
        return new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                return CompareUtility.equals((Object)label, (Object)node.getText());
            }
        };
    }

    public static ITreeNodeFilter getVisible() {
        return new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                return node.isVisible();
            }
        };
    }

    public static ITreeNodeFilter getCombinedFilter(final ITreeNodeFilter[] filters) {
        return new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                ITreeNodeFilter[] iTreeNodeFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNodeFilter f = iTreeNodeFilterArray[n2];
                    if (!f.accept(node)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }

    public static ITreeNodeFilter getAcceptAll() {
        return new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                return true;
            }
        };
    }

    public static ITreeNodeFilter getAcceptNone() {
        return new ITreeNodeFilter(){

            @Override
            public boolean accept(ITreeNode node) {
                return false;
            }
        };
    }
}

