/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalProvider;

public class DefaultProposalProvider
implements IContentProposalProvider {
    private IContentProposalEx[] m_shortList;
    private IContentProposalEx[] m_expertList;

    public DefaultProposalProvider() {
        this(new IContentProposalEx[0]);
    }

    public DefaultProposalProvider(IContentProposalEx[] shortList) {
        this(shortList, null);
    }

    public DefaultProposalProvider(IContentProposalEx[] shortList, IContentProposalEx[] expertList) {
        this.setShortList(shortList);
        this.setExpertList(expertList);
    }

    @Override
    public IContentProposalEx[] getProposalsExpertMode(String content, int cursorPosition, IProgressMonitor monitor) {
        ArrayList<IContentProposalEx> props = new ArrayList<IContentProposalEx>();
        String matchString = content.substring(0, cursorPosition);
        matchString = String.valueOf(matchString.toLowerCase()) + "*";
        IContentProposalEx[] iContentProposalExArray = this.m_expertList;
        int n = this.m_expertList.length;
        int n2 = 0;
        while (n2 < n) {
            IContentProposalEx prop = iContentProposalExArray[n2];
            if (CharOperation.match((char[])matchString.toCharArray(), (char[])prop.getLabel(false, true).toCharArray(), (boolean)false)) {
                props.add(prop);
            }
            ++n2;
        }
        return props.toArray(new IContentProposalEx[props.size()]);
    }

    @Override
    public IContentProposalEx[] getProposals(String content, int cursorPosition, IProgressMonitor monitor) {
        ArrayList<IContentProposalEx> props = new ArrayList<IContentProposalEx>();
        String matchString = content.substring(0, cursorPosition);
        matchString = String.valueOf(matchString.toLowerCase()) + "*";
        IContentProposalEx[] iContentProposalExArray = this.m_shortList;
        int n = this.m_shortList.length;
        int n2 = 0;
        while (n2 < n) {
            IContentProposalEx prop = iContentProposalExArray[n2];
            if (CharOperation.match((char[])matchString.toCharArray(), (char[])prop.getLabel(false, false).toCharArray(), (boolean)false)) {
                props.add(prop);
            }
            ++n2;
        }
        return props.toArray(new IContentProposalEx[props.size()]);
    }

    @Override
    public boolean supportsExpertMode() {
        return this.m_expertList != null && this.m_expertList.length > 0;
    }

    public IContentProposalEx[] getShortList() {
        return this.m_shortList;
    }

    public void setShortList(IContentProposalEx[] shortList) {
        if (shortList == null) {
            shortList = new IContentProposalEx[]{};
        }
        this.m_shortList = shortList;
    }

    public IContentProposalEx[] getExpertList() {
        return this.m_expertList;
    }

    public void setExpertList(IContentProposalEx[] expertList) {
        if (expertList == null) {
            expertList = new IContentProposalEx[]{};
        }
        this.m_expertList = expertList;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultProposalProvider) {
            DefaultProposalProvider compTo = (DefaultProposalProvider)obj;
            if (CompareUtility.equals((Object)this.getShortList(), (Object)compTo.getShortList()) && CompareUtility.equals((Object)this.getExpertList(), (Object)compTo.getExpertList())) {
                return true;
            }
        }
        return false;
    }
}

