/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.swt.graphics.Image;

public class NlsProposal
implements IContentProposalEx {
    private final INlsEntry m_entry;
    private final String m_key;
    private final String m_translation;

    public NlsProposal(INlsEntry entry, Language language) {
        this.m_entry = entry;
        this.m_key = entry.getKey();
        this.m_translation = entry.getTranslation(language, true);
    }

    @Override
    public int getCursorPosition(boolean selected, boolean expertMode) {
        return this.m_translation.length();
    }

    @Override
    public Image getImage(boolean selected, boolean expertMode) {
        return ScoutSdkUi.getImage("text.png");
    }

    @Override
    public String getLabel(boolean selected, boolean expertMode) {
        String value = this.m_translation;
        if (selected) {
            value = String.valueOf(value) + "  (" + this.m_key + ")";
        }
        return value;
    }

    public INlsEntry getNlsEntry() {
        return this.m_entry;
    }
}

