/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.Set;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NlsProposalDescriptionProvider
implements IProposalDescriptionProvider {
    @Override
    public Control createDescriptionContent(Composite parent, IContentProposalEx proposal) {
        if (proposal instanceof NlsProposal) {
            NlsProposal nlsProp = (NlsProposal)proposal;
            String key = nlsProp.getNlsEntry().getKey();
            if (key == null) {
                return null;
            }
            Composite rootArea = new Composite(parent, 2);
            rootArea.setBackground(parent.getBackground());
            Set lanuageSet = nlsProp.getNlsEntry().getAllTranslations().keySet();
            Language[] languageArr = lanuageSet.toArray(new Language[lanuageSet.size()]);
            Label keyLabel = new Label(rootArea, 0);
            keyLabel.setBackground(rootArea.getBackground());
            keyLabel.setFont(ScoutSdkUi.getFont("fontSystemBold"));
            keyLabel.setText(key);
            keyLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
            Canvas splitter = new Canvas(rootArea, 0);
            splitter.setBackground(splitter.getDisplay().getSystemColor(17));
            GridData splitterData = new GridData(-1, 2);
            splitterData.grabExcessHorizontalSpace = true;
            splitterData.horizontalSpan = 2;
            splitterData.horizontalAlignment = 4;
            splitter.setLayoutData((Object)splitterData);
            Language[] languageArray = languageArr;
            int n = languageArr.length;
            int n2 = 0;
            while (n2 < n) {
                Language lang = languageArray[n2];
                Label langLabel = new Label(rootArea, 0);
                langLabel.setBackground(rootArea.getBackground());
                langLabel.setText(String.valueOf(lang.getDispalyName()) + ": ");
                Label transLabel = new Label(rootArea, 0);
                String text = nlsProp.getNlsEntry().getTranslation(lang);
                if (text == null) {
                    text = "";
                }
                transLabel.setText(text);
                transLabel.setBackground(rootArea.getBackground());
                ++n2;
            }
            rootArea.setLayout((Layout)new GridLayout(2, false));
            return rootArea;
        }
        return null;
    }
}

