/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryModifyAction;
import org.eclipse.scout.nls.sdk.ui.action.NlsEntryNewAction;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.ICustomProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.nls.NlsNewProposal;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.nls.NlsTextProposalProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class NlsProposalTextField
extends ProposalTextField {
    private IContentProposalEx m_selectedNlsProposal;
    private INlsProject m_nlsProject;

    public NlsProposalTextField(Composite parent) {
        this(parent, (INlsProject)null);
    }

    public NlsProposalTextField(Composite parent, INlsProject nlsProject) {
        this(parent, nlsProject, 0);
    }

    public NlsProposalTextField(Composite parent, INlsProject nlsProject, int type) {
        super(parent, new NlsTextProposalProvider(), type);
        this.setNlsProject(nlsProject);
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        Menu menu = manager.createContextMenu((Control)this.getTextComponent());
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager managerInside) {
                NlsProposalTextField.this.createContextMenu((MenuManager)managerInside);
            }
        });
        this.getTextComponent().setMenu(menu);
        this.setProposalDescriptionProvider(new NlsProposalDescriptionProvider());
    }

    @Override
    protected void handleCustomProposalSelected(ICustomProposal proposal) {
        if (proposal instanceof NlsNewProposal) {
            String proposalFieldText = "";
            if (this.getLastRequestPattern() != null) {
                proposalFieldText = this.getLastRequestPattern().getSearchText();
            }
            String key = this.getNewKey(proposalFieldText);
            NlsEntry row = new NlsEntry(key, this.getNlsProject());
            row.addTranslation(this.getNlsProject().getDevelopmentLanguage(), proposalFieldText);
            NlsEntryNewAction action = new NlsEntryNewAction(row, true, this.getNlsProject());
            action.run();
            try {
                action.join();
            }
            catch (InterruptedException e) {
                ScoutSdkUi.logWarning(e);
            }
            row = action.getEntry();
            if (row != null) {
                if (this.getNlsProject() != null) {
                    this.getProposalProvider().setNlsEntries(this.getNlsProject().getAllEntries(), this.getNlsProject().getDevelopmentLanguage());
                }
                NlsProposal selectedProposal = new NlsProposal((INlsEntry)row, this.getNlsProject().getDevelopmentLanguage());
                this.acceptProposal(selectedProposal);
                return;
            }
            return;
        }
    }

    protected String getNewKey(String value) {
        List<String> existingKeys = Arrays.asList(this.getNlsProject().getAllKeys());
        if (value == null || value.length() == 0) {
            return null;
        }
        String[] split = value.split(" ");
        value = "";
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String splitValue = stringArray[n2];
            value = String.valueOf(value) + Character.toUpperCase(splitValue.charAt(0)) + (splitValue.length() > 1 ? splitValue.substring(1) : "");
            ++n2;
        }
        String newKey = value;
        int i = 0;
        while (existingKeys.contains(newKey)) {
            newKey = String.valueOf(value) + i++;
        }
        return newKey;
    }

    private void createContextMenu(MenuManager manager) {
        IContentProposalEx prop = this.getSelectedProposal();
        if (prop instanceof NlsProposal) {
            manager.add((IAction)new NlsEntryModifyAction(new NlsEntry(((NlsProposal)prop).getNlsEntry()), true, this.getNlsProject()));
        }
    }

    @Override
    public NlsTextProposalProvider getProposalProvider() {
        return (NlsTextProposalProvider)super.getProposalProvider();
    }

    @Override
    public NlsTextProposalProvider getContentProposalProvider() {
        return (NlsTextProposalProvider)super.getContentProposalProvider();
    }

    public void setNlsProject(INlsProject nlsProject) {
        if (!CompareUtility.equals((Object)nlsProject, (Object)this.m_nlsProject)) {
            this.m_nlsProject = nlsProject;
            if (this.m_nlsProject != null) {
                this.getProposalProvider().setNlsEntries(this.m_nlsProject.getAllEntries(), this.getNlsProject().getDevelopmentLanguage());
            }
        }
    }

    public INlsProject getNlsProject() {
        return this.m_nlsProject;
    }
}

