/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.Window;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalPopupListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalPopupEvent;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProposalPopup
extends Window {
    private static final int POPUP_OFFSET = 2;
    private static final int POPUP_CHAR_HEIGHT = 10;
    private static final int POPUP_MINIMUM_WIDTH = 300;
    private TableViewer m_tableViewer;
    private Label m_itemCountLabel;
    private Button m_showAllProposals;
    private Control m_proposalField;
    private Point popupSize;
    private IContentProposalEx[] m_proposals;
    private boolean m_ignoreClose;
    private List<IProposalPopupListener> m_selectionListeners = new ArrayList<IProposalPopupListener>();
    private boolean m_expertModusChecked;
    private final boolean m_supportsEpertModus;
    private IProposalDescriptionProvider m_proposalDescriptionProvider;
    private ScrolledComposite m_proposalDescriptionArea;

    public ProposalPopup(Control proposalField, boolean supportsExpertModus, boolean expertModusChecked) {
        super(proposalField.getShell());
        this.m_proposalField = proposalField;
        this.m_supportsEpertModus = supportsExpertModus;
        this.m_expertModusChecked = expertModusChecked;
        this.setShellStyle(16400);
        this.setBlockOnOpen(false);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setBackground(shell.getDisplay().getSystemColor(1));
    }

    protected Control createContents(Composite parent) {
        Composite proposalArea = new Composite(parent, 2);
        proposalArea.setBackground(proposalArea.getDisplay().getSystemColor(1));
        Table table = new Table(proposalArea, 66304);
        this.m_tableViewer = new TableViewer(table);
        this.m_tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                IContentProposalEx selectedProposal = null;
                if (!selection.isEmpty() && selection.getFirstElement() instanceof IContentProposalEx) {
                    selectedProposal = (IContentProposalEx)selection.getFirstElement();
                }
                ProposalPopup.this.updateDescription(selectedProposal);
                ProposalPopupEvent delegateEvent = new ProposalPopupEvent(4);
                delegateEvent.setData("selectedProposal", selectedProposal);
                ProposalPopup.this.firePopupEvent(delegateEvent);
            }
        });
        this.m_tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    ProposalPopupEvent delegateEvent = new ProposalPopupEvent(2);
                    delegateEvent.setData("selectedProposal", selection.getFirstElement());
                    ProposalPopup.this.firePopupEvent(delegateEvent);
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: {
                        break;
                    }
                    case 32: {
                        IStructuredSelection selection = (IStructuredSelection)ProposalPopup.this.m_tableViewer.getSelection();
                        if (selection.isEmpty()) break;
                        ProposalPopupEvent delegateEvent = new ProposalPopupEvent(2);
                        delegateEvent.setData("selectedProposal", selection.getFirstElement());
                        ProposalPopup.this.firePopupEvent(delegateEvent);
                        break;
                    }
                }
                super.keyReleased(e);
            }
        });
        table.setHeaderVisible(false);
        this.m_proposalDescriptionArea = new ScrolledComposite(parent, 2816);
        this.m_proposalDescriptionArea.setBackground(this.m_proposalDescriptionArea.getDisplay().getSystemColor(29));
        this.m_proposalDescriptionArea.setExpandHorizontal(true);
        this.m_proposalDescriptionArea.setExpandVertical(true);
        Group group = new Group(proposalArea, 64);
        group.setBackground(group.getDisplay().getSystemColor(1));
        group.setForeground(group.getDisplay().getSystemColor(9));
        this.m_itemCountLabel = new Label((Composite)group, 0);
        this.m_itemCountLabel.setBackground(this.m_itemCountLabel.getDisplay().getSystemColor(1));
        this.m_showAllProposals = new Button((Composite)group, 32);
        this.m_showAllProposals.setBackground(this.m_showAllProposals.getDisplay().getSystemColor(1));
        this.m_showAllProposals.setText(Texts.get((String)"ProposalField_checkBox_showAllProposals"));
        this.m_showAllProposals.setEnabled(this.m_supportsEpertModus);
        this.m_showAllProposals.setSelection(this.m_expertModusChecked);
        this.m_showAllProposals.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProposalPopupEvent event = new ProposalPopupEvent(16);
                event.setData("selectionSearchShortened", new Boolean(ProposalPopup.this.m_showAllProposals.getSelection()));
                ProposalPopup.this.firePopupEvent(event);
            }
        });
        GridLayout parentLayout = new GridLayout(1, true);
        parentLayout.horizontalSpacing = 0;
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parentLayout.verticalSpacing = 0;
        parent.setLayout((Layout)parentLayout);
        GridData proposalAreaData = new GridData(1808);
        proposalAreaData.heightHint = 300;
        proposalAreaData.widthHint = 300;
        proposalArea.setLayoutData((Object)new GridData(1808));
        GridData proposalDescriptionData = new GridData(1808);
        proposalDescriptionData.heightHint = 300;
        proposalDescriptionData.widthHint = 300;
        proposalDescriptionData.exclude = true;
        this.m_proposalDescriptionArea.setLayoutData((Object)proposalDescriptionData);
        proposalArea.setLayout((Layout)new FormLayout());
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)group, -2);
        table.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, -2);
        data.bottom = new FormAttachment(100, -2);
        group.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        group.setLayout((Layout)gridLayout);
        GridData gd = new GridData(769);
        this.m_itemCountLabel.setLayoutData((Object)gd);
        gd = new GridData(3);
        this.m_showAllProposals.setLayoutData((Object)gd);
        return parent;
    }

    public void setProposals(IContentProposalEx[] proposals) {
        if (proposals == null) {
            proposals = new IContentProposalEx[]{};
        }
        this.m_proposals = proposals;
        try {
            this.m_tableViewer.getTable().setRedraw(false);
            this.m_tableViewer.getTable().setItemCount(proposals.length);
            TableItem[] items = this.m_tableViewer.getTable().getItems();
            int i = 0;
            while (i < items.length) {
                TableItem item = items[i];
                IContentProposalEx proposal = proposals[i];
                int selectionIndex = this.m_tableViewer.getTable().getSelectionIndex();
                boolean selected = i == selectionIndex;
                item.setText(this.getText(proposal, selected));
                item.setImage(this.getImage(proposal, selected));
                item.setData((Object)proposal);
                ++i;
            }
        }
        finally {
            this.m_tableViewer.getTable().setRedraw(true);
        }
        if (this.m_tableViewer.getSelection().isEmpty()) {
            Object proposal = this.m_tableViewer.getElementAt(0);
            this.m_tableViewer.setSelection((ISelection)new StructuredSelection(proposal));
        }
        this.m_itemCountLabel.setText(String.valueOf(proposals.length) + " items found");
        this.updateDescription(this.getSelectedProposal());
    }

    public int open() {
        Shell shell = this.getShell();
        if (shell == null || shell.isDisposed()) {
            shell = null;
            this.create();
            shell = this.getShell();
        }
        this.adjustBounds();
        this.constrainShellSize();
        shell.setVisible(true);
        return 0;
    }

    private void updateDescription(IContentProposalEx proposal) {
        Control[] controlArray = this.m_proposalDescriptionArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed()) {
                c.dispose();
            }
            ++n2;
        }
        if (this.getProposalDescriptionProvider() != null) {
            Control content = this.getProposalDescriptionProvider().createDescriptionContent((Composite)this.m_proposalDescriptionArea, proposal);
            if (content != null) {
                ((GridLayout)this.m_proposalDescriptionArea.getParent().getLayout()).numColumns = 2;
                this.m_proposalDescriptionArea.setContent(content);
                this.m_proposalDescriptionArea.setMinSize(content.computeSize(-1, -1));
                ((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude = false;
            } else {
                ((GridLayout)this.m_proposalDescriptionArea.getParent().getLayout()).numColumns = 1;
                ((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude = true;
            }
            this.adjustBounds();
        }
    }

    public void setIgnoreClose(boolean ignore) {
        this.m_ignoreClose = ignore;
    }

    public void setProposalDescriptionProvider(IProposalDescriptionProvider proposalDescriptionProvider) {
        this.m_proposalDescriptionProvider = proposalDescriptionProvider;
    }

    public IProposalDescriptionProvider getProposalDescriptionProvider() {
        return this.m_proposalDescriptionProvider;
    }

    public boolean close() {
        if (this.m_ignoreClose) {
            return false;
        }
        this.firePopupEvent(new ProposalPopupEvent(8));
        return super.close();
    }

    public boolean isFocusOwner() {
        Control focusControl = this.getShell().getDisplay().getFocusControl();
        return focusControl != null && focusControl.getShell() == this.getShell();
    }

    public void addPopupListener(IProposalPopupListener proposalSelectionListener) {
        this.m_selectionListeners.add(proposalSelectionListener);
    }

    public void removePopupListener(IProposalPopupListener proposalSelectionListener) {
        this.m_selectionListeners.remove(proposalSelectionListener);
    }

    public void setExpertMode(boolean searchExpertMode) {
        this.m_expertModusChecked = searchExpertMode;
        this.m_showAllProposals.setSelection(searchExpertMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePopupEvent(ProposalPopupEvent event) {
        IProposalPopupListener[] listeners;
        List<IProposalPopupListener> list = this.m_selectionListeners;
        synchronized (list) {
            listeners = this.m_selectionListeners.toArray(new IProposalPopupListener[this.m_selectionListeners.size()]);
        }
        IProposalPopupListener[] iProposalPopupListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalPopupListener listener = iProposalPopupListenerArray[n2];
            listener.popupChanged(event);
            ++n2;
        }
    }

    IContentProposalEx getSelectedProposal() {
        IStructuredSelection selection = (IStructuredSelection)this.m_tableViewer.getSelection();
        if (!selection.isEmpty()) {
            return (IContentProposalEx)selection.getFirstElement();
        }
        return null;
    }

    private String getText(IContentProposalEx proposal, boolean selected) {
        return proposal.getLabel(selected, this.m_expertModusChecked);
    }

    private Image getImage(IContentProposalEx proposal, boolean selected) {
        return proposal.getImage(selected, this.m_expertModusChecked);
    }

    boolean setFocus() {
        return this.m_tableViewer.getTable().setFocus();
    }

    private void adjustBounds() {
        Point location = this.m_proposalField.getDisplay().map((Control)this.m_proposalField.getParent(), null, this.m_proposalField.getLocation());
        int initialX = location.x + 2;
        int initialY = location.y + this.m_proposalField.getSize().y + 2;
        Point size = this.getShell().computeSize(-1, -1);
        size.x = ((GridData)this.m_proposalDescriptionArea.getLayoutData()).exclude ? 300 : 600;
        size.y = 300;
        this.getShell().setBounds(initialX, initialY, size.x, size.y);
    }
}

