/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.TextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ICustomProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalDescriptionProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalPopupListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ISeparatorProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.Lock;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalPopup;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalPopupEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class ProposalTextField
extends TextField {
    public static int TYPE_INITIAL_SHOW_POPUP = 2;
    public static int TYPE_SEARCH_EXPERT_MODE = 4;
    public static int TYPE_NO_LABEL = 1024;
    private IContentProposalProvider m_proposalProvider;
    private Button m_popupButton;
    private ProposalPopup m_popup;
    private P_ProposalFieldListener m_proposalFieldListener;
    private IContentProposalEx m_loadingProposal = new ISeparatorProposal(){

        @Override
        public String getLabel(boolean selected, boolean expertMode) {
            return "Loading...";
        }

        @Override
        public Image getImage(boolean selected, boolean expertMode) {
            return ScoutSdkUi.getImage("progress_monitor.gif");
        }

        @Override
        public int getCursorPosition(boolean selected, boolean expertMode) {
            return 0;
        }
    };
    private P_ProposalLoaderJob m_currentLoader = null;
    private Object lockProposalAdpter = new Object();
    private IContentProposalEx m_selectedProposal = null;
    private IContentProposalEx m_focusGainedProposal = null;
    private IContentProposalEx m_lastFiredProposal = null;
    private P_RequestPattern m_lastRequestPattern;
    private EventListenerList m_eventListeners = new EventListenerList();
    private Lock m_updateLock = new Lock();
    private Lock m_focusLock = new Lock();
    private IProposalPopupListener m_popupListener = new P_PopupListener();
    private int m_type;
    private boolean m_searchExpertMode;
    private IProposalDescriptionProvider m_proposalDescriptionProvider;

    public ProposalTextField(Composite parent) {
        this(parent, (IContentProposalProvider)null);
    }

    public ProposalTextField(Composite parent, IContentProposalProvider proposalProvider) {
        this(parent, proposalProvider, 0);
    }

    public ProposalTextField(Composite parent, IContentProposalProvider proposalProvider, int type) {
        super(parent);
        this.m_type = type;
        this.setContentProposalProvider(proposalProvider);
        this.init();
    }

    public void setContentProposalProvider(IContentProposalProvider provider) {
        if (!CompareUtility.equals((Object)provider, (Object)this.m_proposalProvider)) {
            this.m_lastRequestPattern = null;
            this.acceptProposal(null);
            this.m_proposalProvider = provider;
            if (this.m_proposalProvider == null) {
                this.detachProposalListener(this.getTextComponent());
            } else {
                this.attachProposalListener(this.getTextComponent());
            }
        }
    }

    public IContentProposalProvider getContentProposalProvider() {
        return this.m_proposalProvider;
    }

    private void attachProposalListener(StyledText textComponent) {
        if (this.m_proposalFieldListener == null) {
            this.m_proposalFieldListener = new P_ProposalFieldListener();
            textComponent.addListener(1, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(2, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(24, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(16, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(15, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(31, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(4, (Listener)this.m_proposalFieldListener);
            textComponent.addListener(25, (Listener)this.m_proposalFieldListener);
        }
    }

    private void detachProposalListener(StyledText textComponent) {
        if (this.m_proposalFieldListener != null) {
            textComponent.removeListener(1, (Listener)this.m_proposalFieldListener);
            textComponent.removeListener(2, (Listener)this.m_proposalFieldListener);
            textComponent.removeListener(24, (Listener)this.m_proposalFieldListener);
            textComponent.removeListener(16, (Listener)this.m_proposalFieldListener);
            textComponent.removeListener(15, (Listener)this.m_proposalFieldListener);
            textComponent.removeListener(31, (Listener)this.m_proposalFieldListener);
            textComponent.removeListener(4, (Listener)this.m_proposalFieldListener);
            textComponent.removeListener(25, (Listener)this.m_proposalFieldListener);
            this.m_proposalFieldListener = null;
        }
    }

    private void init() {
        Label label = this.getLabelComponent();
        StyledText text = this.getTextComponent();
        FormData labelData = (FormData)label.getLayoutData();
        FormData textData = (FormData)text.getLayoutData();
        if ((this.m_type & TYPE_NO_LABEL) != 0) {
            label.setVisible(false);
            labelData.right = new FormAttachment(0, 0);
            textData.left = new FormAttachment(0, 0);
        }
    }

    @Override
    protected void createContent(Composite parent) {
        super.createContent(parent);
        Label label = this.getLabelComponent();
        StyledText text = this.getTextComponent();
        this.m_popupButton = new Button(parent, 8);
        this.m_popupButton.setImage(ScoutSdkUi.getImage("down.gif"));
        this.m_popupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (ProposalTextField.this.m_updateLock.aquire()) {
                        if (ProposalTextField.this.m_popup != null) {
                            ProposalTextField.this.m_popup.close();
                        } else {
                            ProposalTextField.this.getTextComponent().setSelection(0);
                            ProposalTextField.this.getTextComponent().setFocus();
                            ProposalTextField.this.updateProposals();
                        }
                    }
                }
                finally {
                    ProposalTextField.this.m_updateLock.release();
                }
            }
        });
        parent.setTabList(new Control[]{text});
        parent.setLayout((Layout)new FormLayout());
        FormData labelData = new FormData();
        labelData.top = new FormAttachment(0, 0);
        labelData.left = new FormAttachment(0, 0);
        labelData.right = new FormAttachment(40, 0);
        labelData.bottom = new FormAttachment(100, 0);
        label.setLayoutData((Object)labelData);
        FormData textData = new FormData();
        textData.top = new FormAttachment(0, 0);
        textData.left = new FormAttachment((Control)label, 5);
        textData.right = new FormAttachment((Control)this.m_popupButton, -2);
        textData.bottom = new FormAttachment(100, 0);
        text.setLayoutData((Object)textData);
        FormData buttonData = new FormData(22, 22);
        buttonData.top = new FormAttachment(0, 0);
        buttonData.right = new FormAttachment(100, 0);
        buttonData.bottom = new FormAttachment(100, 0);
        this.m_popupButton.setLayoutData((Object)buttonData);
    }

    public void addProposalAdapterListener(IProposalAdapterListener listener) {
        this.m_eventListeners.add(IProposalAdapterListener.class, (EventListener)listener);
    }

    public void removeProposalAdapterListener(IProposalAdapterListener listener) {
        this.m_eventListeners.remove(IProposalAdapterListener.class, (EventListener)listener);
    }

    public IContentProposalProvider getProposalProvider() {
        return this.m_proposalProvider;
    }

    protected P_RequestPattern getLastRequestPattern() {
        return this.m_lastRequestPattern;
    }

    protected void notifyAcceptProposalUpdateUi(IContentProposalEx proposal) {
        try {
            if (this.m_updateLock.aquire()) {
                if (proposal != null) {
                    this.getTextComponent().setText(proposal.getLabel(false, this.m_searchExpertMode));
                    this.getTextComponent().setSelection(proposal.getCursorPosition(this.m_searchExpertMode, false));
                } else {
                    this.getTextComponent().setText("");
                    this.getTextComponent().setSelection(0);
                }
            }
        }
        finally {
            this.m_updateLock.release();
        }
        this.m_selectedProposal = proposal;
        this.notifyAcceptProposal(proposal);
    }

    protected void notifyAcceptProposal(IContentProposalEx proposal) {
        ContentProposalEvent event = new ContentProposalEvent((Object)this);
        event.proposal = proposal;
        if (this.m_lastRequestPattern == null) {
            event.text = "";
            event.cursorPosition = 0;
        } else {
            event.text = this.m_lastRequestPattern.getSearchText();
            event.cursorPosition = this.m_lastRequestPattern.getPosition();
        }
        IProposalAdapterListener[] iProposalAdapterListenerArray = (IProposalAdapterListener[])this.m_eventListeners.getListeners(IProposalAdapterListener.class);
        int n = iProposalAdapterListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProposalAdapterListener l = iProposalAdapterListenerArray[n2];
            l.proposalAccepted(event);
            ++n2;
        }
        this.m_lastFiredProposal = proposal;
    }

    public synchronized void acceptProposal(IContentProposalEx selectedProposal) {
        if (selectedProposal instanceof ISeparatorProposal) {
            return;
        }
        if (selectedProposal instanceof ICustomProposal) {
            this.handleCustomProposalSelected((ICustomProposal)selectedProposal);
            return;
        }
        try {
            if (this.m_updateLock.aquire()) {
                if (selectedProposal == null) {
                    this.getTextComponent().setText("");
                    this.getTextComponent().setSelection(1);
                } else {
                    this.getTextComponent().setText(selectedProposal.getLabel(false, this.m_searchExpertMode));
                    this.getTextComponent().setSelection(selectedProposal.getCursorPosition(this.m_searchExpertMode, false));
                }
            }
        }
        finally {
            this.m_updateLock.release();
        }
        if (!CompareUtility.equals((Object)this.m_selectedProposal, (Object)selectedProposal)) {
            this.m_selectedProposal = selectedProposal;
            this.notifyAcceptProposal(this.m_selectedProposal);
        }
        this.closePopup();
    }

    protected void handleCustomProposalSelected(ICustomProposal proposal) {
    }

    public void setProposalDescriptionProvider(IProposalDescriptionProvider proposalDescriptionProvider) {
        this.m_proposalDescriptionProvider = proposalDescriptionProvider;
    }

    public IProposalDescriptionProvider getProposalDescriptionProvider() {
        return this.m_proposalDescriptionProvider;
    }

    @Override
    public void setText(String text) {
        if (this.m_updateLock.aquire()) {
            try {
                if (text == null) {
                    text = "";
                }
                super.setText(text);
            }
            finally {
                this.m_updateLock.release();
            }
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(editable);
        }
    }

    @Override
    public boolean getEditable() {
        boolean editable = super.getEditable();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            editable = editable && this.m_popupButton.getEnabled();
        }
        return editable;
    }

    @Override
    public boolean isEditable() {
        boolean editable = super.isEditable();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            editable = editable && this.m_popupButton.getEnabled();
        }
        return editable;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            this.m_popupButton.setEnabled(enabled);
        }
    }

    @Override
    public boolean getEnabled() {
        boolean enabled = super.getEnabled();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            enabled = enabled && this.m_popupButton.getEnabled();
        }
        return enabled;
    }

    public boolean isEnabled() {
        boolean enabled = super.isEnabled();
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            enabled = enabled && this.m_popupButton.getEnabled();
        }
        return enabled;
    }

    protected synchronized void closePopup() {
        if (this.m_popup != null) {
            this.m_popup.close();
        }
    }

    private synchronized void updateProposals() {
        P_RequestPattern searchPattern = new P_RequestPattern(this.getText(), this.getSelection().x);
        if (searchPattern.equals(this.m_lastRequestPattern)) {
            this.showProposals(this.m_lastRequestPattern);
            return;
        }
        if (this.m_currentLoader != null) {
            this.m_currentLoader.cancel();
        }
        if (this.m_popup != null) {
            this.m_popup.setProposals(new IContentProposalEx[]{this.m_loadingProposal});
        }
        this.m_currentLoader = new P_ProposalLoaderJob(searchPattern);
        this.m_currentLoader.schedule();
    }

    private synchronized void textModified() {
        String text = this.getText();
        int cursorPosition = this.getSelection().x;
        if (cursorPosition > 0 && this.m_selectedProposal != null && this.m_selectedProposal.getLabel(this.m_searchExpertMode, false).equals(text.substring(0, cursorPosition))) {
            return;
        }
        this.updateProposals();
    }

    private boolean isProposalFieldFocusOwner() {
        if (this.m_popup != null) {
            if (this.m_popup.isFocusOwner()) {
                return true;
            }
            Shell[] shells = this.m_popup.getShell().getShells();
            if (shells != null && shells.length > 0) {
                return true;
            }
        }
        if (this.getTextComponent() != null && !this.getTextComponent().isDisposed() && this.getTextComponent().isFocusControl()) {
            return true;
        }
        if (this.m_popupButton != null && !this.m_popupButton.isDisposed()) {
            return this.m_popupButton.isFocusControl();
        }
        return false;
    }

    private synchronized void showProposals(P_RequestPattern searchPattern) {
        this.m_lastRequestPattern = searchPattern;
        if (this.m_lastRequestPattern.getProposals().length == 0) {
            if (this.m_popup != null) {
                this.closePopup();
            }
        } else {
            if (this.m_popup == null) {
                this.openPopup();
            }
            this.m_popup.setExpertMode(this.m_searchExpertMode);
            this.m_popup.setProposals(this.m_lastRequestPattern.getProposals());
        }
    }

    private synchronized void openPopup() {
        this.m_popup = new ProposalPopup((Control)this.getTextComponent(), this.m_proposalProvider.supportsExpertMode(), this.m_searchExpertMode);
        this.m_popup.setProposalDescriptionProvider(this.m_proposalDescriptionProvider);
        this.m_popup.open();
        this.m_popup.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (ProposalTextField.this.m_popup != null) {
                    ProposalTextField.this.m_popup.removePopupListener(ProposalTextField.this.m_popupListener);
                }
                ProposalTextField.this.m_popup = null;
            }
        });
        this.m_popup.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                ProposalTextField.this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ProposalTextField.this.isProposalFieldFocusOwner()) {
                            ProposalTextField.this.closePopup();
                        }
                    }
                });
            }
        });
        this.m_popup.addPopupListener(this.m_popupListener);
    }

    private boolean equalProposals(IContentProposalEx prop1, IContentProposalEx prop2) {
        if (prop1 == null) {
            return prop2 == null;
        }
        return prop1.equals(prop2);
    }

    public IContentProposalEx getSelectedProposal() {
        return this.m_selectedProposal;
    }

    private class P_PopupListener
    implements IProposalPopupListener {
        private P_PopupListener() {
        }

        @Override
        public void popupChanged(ProposalPopupEvent event) {
            switch (event.getType()) {
                case 2: {
                    try {
                        ProposalTextField.this.m_focusLock.aquire();
                        ProposalTextField.this.acceptProposal((IContentProposalEx)event.getData("selectedProposal"));
                        ProposalTextField.this.getTextComponent().traverse(16);
                        break;
                    }
                    finally {
                        ProposalTextField.this.m_focusLock.release();
                    }
                }
                case 16: {
                    ProposalTextField.this.m_searchExpertMode = (Boolean)event.getData("selectionSearchShortened");
                    ProposalTextField.this.m_lastRequestPattern = null;
                    ProposalTextField.this.updateProposals();
                    break;
                }
                case 4: {
                    ProposalTextField.this.updateProposals();
                    break;
                }
                case 8: {
                    if (!ProposalTextField.this.m_focusLock.aquire()) break;
                    try {
                        CompareUtility.equals((Object)ProposalTextField.this.m_lastFiredProposal, (Object)ProposalTextField.this.m_selectedProposal);
                        ProposalTextField.this.m_popup.close();
                        break;
                    }
                    finally {
                        ProposalTextField.this.m_focusLock.release();
                    }
                }
            }
        }
    }

    private class P_ProposalFieldListener
    implements Listener {
        private P_ProposalFieldListener() {
        }

        public void handleEvent(Event event) {
            block2 : switch (event.type) {
                case 24: {
                    if (!ProposalTextField.this.m_updateLock.aquire()) break;
                    try {
                        ProposalTextField.this.textModified();
                        break;
                    }
                    finally {
                        ProposalTextField.this.m_updateLock.release();
                    }
                }
                case 25: {
                    if (!"\t".equals(event.text)) break;
                    event.doit = false;
                    break;
                }
                case 2: {
                    switch (event.keyCode) {
                        case 27: {
                            ProposalTextField.this.closePopup();
                            event.doit = false;
                            break block2;
                        }
                        case 0x1000002: {
                            if (ProposalTextField.this.m_popup == null) {
                                ProposalTextField.this.updateProposals();
                                break block2;
                            }
                            ProposalTextField.this.m_popup.setFocus();
                            break block2;
                        }
                        case 0x1000003: 
                        case 0x1000004: {
                            ProposalTextField.this.textModified();
                            break block2;
                        }
                        case 101: {
                            if (event.stateMask != 262144) break block2;
                            ProposalTextField.this.m_searchExpertMode = !ProposalTextField.this.m_searchExpertMode;
                            ProposalTextField.this.m_lastRequestPattern = null;
                            ProposalTextField.this.updateProposals();
                            break block2;
                        }
                    }
                    break;
                }
                case 16: {
                    ProposalTextField.this.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ProposalTextField.this.m_popupButton != null && !ProposalTextField.this.m_popupButton.isDisposed() && CompareUtility.equals((Object)ProposalTextField.this.getDisplay().getFocusControl(), (Object)ProposalTextField.this.m_popupButton)) {
                                return;
                            }
                            if (!ProposalTextField.this.isProposalFieldFocusOwner() && !ProposalTextField.this.isDisposed()) {
                                String text = ProposalTextField.this.getText();
                                String input = "";
                                if (ProposalTextField.this.m_selectedProposal != null) {
                                    input = ProposalTextField.this.m_selectedProposal.getLabel(false, ProposalTextField.this.m_searchExpertMode);
                                }
                                if (!StringUtility.equalsIgnoreCase((String)text, (String)input)) {
                                    ProposalTextField.this.acceptProposal(null);
                                }
                                ProposalTextField.this.closePopup();
                            }
                        }
                    });
                    break;
                }
                case 15: {
                    if (ProposalTextField.this.m_focusLock.aquire()) {
                        try {
                            ProposalTextField.this.m_focusGainedProposal = ProposalTextField.this.m_selectedProposal;
                        }
                        finally {
                            ProposalTextField.this.m_focusLock.release();
                        }
                    }
                    if ((ProposalTextField.this.m_type & TYPE_INITIAL_SHOW_POPUP) == 0) break;
                    ProposalTextField.this.updateProposals();
                    break;
                }
                case 4: {
                    if (ProposalTextField.this.getText().length() <= 0) break;
                    ProposalTextField.this.textModified();
                    break;
                }
                case 31: {
                    switch (event.keyCode) {
                        case 27: {
                            if (ProposalTextField.this.m_popup == null) break block2;
                            event.doit = false;
                            break block2;
                        }
                        case 13: {
                            if (ProposalTextField.this.m_popup == null) break block2;
                            ProposalTextField.this.acceptProposal(ProposalTextField.this.m_popup.getSelectedProposal());
                            event.doit = false;
                            break block2;
                        }
                        case 9: 
                        case 10: {
                            if (ProposalTextField.this.m_popup == null) break block2;
                            event.doit = false;
                            ProposalTextField.this.m_popup.setFocus();
                            break block2;
                        }
                    }
                    break;
                }
            }
        }
    }

    private class P_ProposalLoaderJob
    extends Job {
        private final P_RequestPattern m_requestPattern;
        private IProgressMonitor m_monitor;

        public P_ProposalLoaderJob(P_RequestPattern requestPattern) {
            super("Load proposals");
            this.m_requestPattern = requestPattern;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            IContentProposalEx[] proposals;
            this.m_monitor = monitor;
            Object object = ProposalTextField.this.lockProposalAdpter;
            synchronized (object) {
                proposals = ProposalTextField.this.m_searchExpertMode ? ProposalTextField.this.m_proposalProvider.getProposalsExpertMode(this.m_requestPattern.getSearchText(), this.m_requestPattern.getPosition(), monitor) : ProposalTextField.this.m_proposalProvider.getProposals(this.m_requestPattern.getSearchText(), this.m_requestPattern.getPosition(), monitor);
            }
            if (this.m_monitor.isCanceled()) {
                return Status.OK_STATUS;
            }
            this.m_requestPattern.setProposals(proposals);
            ProposalTextField.this.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (P_ProposalLoaderJob.this.m_monitor.isCanceled()) {
                        return;
                    }
                    ProposalTextField.this.showProposals(P_ProposalLoaderJob.this.m_requestPattern);
                }
            });
            return Status.OK_STATUS;
        }

        void setCanceled() {
            this.m_monitor.setCanceled(true);
        }
    }

    protected class P_RequestPattern {
        private final int m_position;
        private final String m_searchText;
        private IContentProposalEx[] m_proposals;

        public P_RequestPattern(String text, int position) {
            this.m_searchText = text;
            this.m_position = position;
        }

        public int getPosition() {
            return this.m_position;
        }

        public String getSearchText() {
            return this.m_searchText;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof P_RequestPattern)) {
                return false;
            }
            P_RequestPattern toCheck = (P_RequestPattern)obj;
            return this.getPosition() == toCheck.getPosition() && this.getSearchText().equals(toCheck.getSearchText());
        }

        public IContentProposalEx[] getProposals() {
            return this.m_proposals;
        }

        public void setProposals(IContentProposalEx[] proposals) {
            this.m_proposals = proposals;
        }
    }
}

