/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.icon.IIconProvider;
import org.eclipse.scout.sdk.icon.ScoutIconDesc;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.IconProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.ScoutBundleProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.TypeProposal;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.BundleTypeProposal;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.ConstantFieldProposal;
import org.eclipse.scout.sdk.util.ScoutSourceUtilities;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ScoutProposalUtility {
    private static final ScoutProposalUtility instance = new ScoutProposalUtility();
    private ImageRegistry m_projectImageRegistiry;
    private ITypeProposal[] m_beanPropertyTypeProposals;
    private ITypeProposal[] m_menuShortListProposals;
    private ConstantFieldProposal<Integer>[] m_buttonDisplayTypeProposals;
    private ConstantFieldProposal<String>[] m_formViewIdTypeProposals;
    private ConstantFieldProposal<Integer>[] m_buttonSystemTypeProposals;
    private ConstantFieldProposal<Integer>[] m_formDisplayHintProposals;
    private ConstantFieldProposal<Integer>[] m_verticalAlignmentProposals;
    private ConstantFieldProposal<Integer>[] m_horizontalAlignmentProposals;
    private ITypeProposal[] m_pageShortListProposals;
    private BundleTypeProposal[] m_bundleTypes;

    private ScoutProposalUtility() {
    }

    public static SiblingProposal[] getSiblingProposals(IType[] types) {
        ArrayList<SiblingProposal> siblings = new ArrayList<SiblingProposal>();
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            siblings.add(new SiblingProposal(t));
            ++n2;
        }
        siblings.add(SiblingProposal.SIBLING_END);
        return siblings.toArray(new SiblingProposal[siblings.size()]);
    }

    public static ITypeProposal[] getScoutTypeProposalsFor(IType ... types) {
        ITypeProposal[] props = new ITypeProposal[types.length];
        int i = 0;
        while (i < types.length) {
            props[i] = new TypeProposal(types[i]);
            ++i;
        }
        return props;
    }

    public static ScoutBundleProposal[] getBundleProposals(IScoutBundle ... bundles) {
        ScoutBundleProposal[] props = new ScoutBundleProposal[bundles.length];
        int i = 0;
        while (i < bundles.length) {
            props[i] = new ScoutBundleProposal(bundles[i]);
            ++i;
        }
        return props;
    }

    public static ITypeProposal[] getBcTypeProposalsFor(String ... types) {
        ITypeProposal[] props = new ITypeProposal[types.length];
        int i = 0;
        while (i < types.length) {
            props[i] = new TypeProposal(types[i]);
            ++i;
        }
        return props;
    }

    public static ITypeProposal[] getBcTypeProposals() throws JavaModelException {
        return instance.getBcTypeProposalsImpl();
    }

    private ITypeProposal[] getBcTypeProposalsImpl() throws JavaModelException {
        if (this.m_beanPropertyTypeProposals == null) {
            this.m_beanPropertyTypeProposals = new ITypeProposal[]{new TypeProposal(ScoutSdk.getType((String)ArrayList.class.getName())), new TypeProposal(ScoutSdk.getType((String)Boolean.class.getName())), new TypeProposal(ScoutSdk.getType((String)Collection.class.getName())), new TypeProposal(ScoutSdk.getType((String)Date.class.getName())), new TypeProposal(ScoutSdk.getType((String)Double.class.getName())), new TypeProposal(ScoutSdk.getType((String)Enumeration.class.getName())), new TypeProposal(ScoutSdk.getType((String)Float.class.getName())), new TypeProposal(ScoutSdk.getType((String)HashMap.class.getName())), new TypeProposal(ScoutSdk.getType((String)Integer.class.getName())), new TypeProposal(ScoutSdk.getType((String)List.class.getName())), new TypeProposal(ScoutSdk.getType((String)Long.class.getName())), new TypeProposal(ScoutSdk.getType((String)Map.class.getName())), new TypeProposal(ScoutSdk.getType((String)Number.class.getName())), new TypeProposal(ScoutSdk.getType((String)Object.class.getName())), new TypeProposal(ScoutSdk.getType((String)Runnable.class.getName())), new TypeProposal(ScoutSdk.getType((String)Set.class.getName())), new TypeProposal(ScoutSdk.getType((String)String.class.getName())), new TypeProposal(ScoutSdk.getType((String)TreeMap.class.getName())), new TypeProposal(ScoutSdk.getType((String)TreeSet.class.getName())), new TypeProposal(ScoutSdk.getType((String)Vector.class.getName()))};
        }
        return this.m_beanPropertyTypeProposals;
    }

    public static ITypeProposal[] getMenuShortListProposals() {
        return instance.getMenuShortListProposalsImpl();
    }

    private ITypeProposal[] getMenuShortListProposalsImpl() {
        if (this.m_menuShortListProposals == null) {
            this.m_menuShortListProposals = new ITypeProposal[]{new TypeProposal("org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu"), new TypeProposal("org.eclipse.scout.rt.client.ui.desktop.bookmark.menu.AbstractBookmarkMenu"), new TypeProposal("org.eclipse.scout.rt.client.ui.action.menu.checkbox.AbstractCheckBoxMenu")};
        }
        return this.m_menuShortListProposals;
    }

    public static ConstantFieldProposal<Integer>[] getButtonDisplayTypeProposals() {
        return instance.getButtonDisplayTypeProposalsImpl();
    }

    private ConstantFieldProposal<Integer>[] getButtonDisplayTypeProposalsImpl() {
        if (this.m_buttonDisplayTypeProposals == null) {
            IType buttonType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.IButton");
            this.m_buttonDisplayTypeProposals = new ConstantFieldProposal[]{new ConstantFieldProposal<Integer>("Default", ScoutSdkUi.getImage("default.gif"), buttonType.getField("DISPLAY_STYLE_DEFAULT"), 0), new ConstantFieldProposal<Integer>("Radio", ScoutSdkUi.getImage("default.gif"), buttonType.getField("DISPLAY_STYLE_RADIO"), 2), new ConstantFieldProposal<Integer>("Toggle", ScoutSdkUi.getImage("default.gif"), buttonType.getField("DISPLAY_STYLE_TOGGLE"), 1), new ConstantFieldProposal<Integer>("Link", ScoutSdkUi.getImage("default.gif"), buttonType.getField("DISPLAY_STYLE_LINK"), 3)};
        }
        return this.m_buttonDisplayTypeProposals;
    }

    public static ConstantFieldProposal<String>[] getFormViewIdTypeProposals() {
        return instance.getFormViewIdTypeProposalsImpl();
    }

    private ConstantFieldProposal<String>[] getFormViewIdTypeProposalsImpl() {
        if (this.m_formViewIdTypeProposals == null) {
            IType iformType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
            this.m_formViewIdTypeProposals = new ConstantFieldProposal[]{new ConstantFieldProposal<String>("Outline", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_OUTLINE"), "OUTLINE"), new ConstantFieldProposal<String>("Outline Selector", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_OUTLINE_SELECTOR"), "OUTLINE_SELECTOR"), new ConstantFieldProposal<String>("Page Table", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_PAGE_TABLE"), "PAGE_TABLE"), new ConstantFieldProposal<String>("Page Detail", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_PAGE_DETAIL"), "PAGE_DETAIL"), new ConstantFieldProposal<String>("Page Search", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_PAGE_SEARCH"), "PAGE_SEARCH"), new ConstantFieldProposal<String>("Editor", ScoutSdkUi.getImage("default.gif"), iformType.getField("EDITOR_ID"), "EDITOR"), new ConstantFieldProposal<String>("North", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_N"), "N"), new ConstantFieldProposal<String>("North-East", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_NE"), "NE"), new ConstantFieldProposal<String>("East", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_E"), "E"), new ConstantFieldProposal<String>("South-East", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_SE"), "SE"), new ConstantFieldProposal<String>("South", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_S"), "S"), new ConstantFieldProposal<String>("South-West", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_SW"), "SW"), new ConstantFieldProposal<String>("West", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_W"), "W"), new ConstantFieldProposal<String>("NorthWest", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_NW"), "NW"), new ConstantFieldProposal<String>("Center", ScoutSdkUi.getImage("default.gif"), iformType.getField("VIEW_ID_CENTER"), "C")};
        }
        return this.m_formViewIdTypeProposals;
    }

    public static ConstantFieldProposal<Integer>[] getButtonSystemTypeProposals() {
        return instance.getButtonSystemTypeProposalsImpl();
    }

    private ConstantFieldProposal<Integer>[] getButtonSystemTypeProposalsImpl() {
        if (this.m_buttonSystemTypeProposals == null) {
            IType buttonType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.button.IButton");
            this.m_buttonSystemTypeProposals = new ConstantFieldProposal[]{new ConstantFieldProposal<Integer>("None", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_NONE"), 0), new ConstantFieldProposal<Integer>("Cancel", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_CANCEL"), 1), new ConstantFieldProposal<Integer>("Close", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_CLOSE"), 2), new ConstantFieldProposal<Integer>("Ok", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_OK"), 3), new ConstantFieldProposal<Integer>("Reset", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_RESET"), 4), new ConstantFieldProposal<Integer>("Save", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_SAVE"), 5), new ConstantFieldProposal<Integer>("Save Search", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_SAVE_WITHOUT_MARKER_CHANGE"), 6), new ConstantFieldProposal<Integer>("Back", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_WIZARD_BACK"), 7), new ConstantFieldProposal<Integer>("Next", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_WIZARD_NEXT"), 8), new ConstantFieldProposal<Integer>("Finish", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_WIZARD_FINISH"), 9), new ConstantFieldProposal<Integer>("Suspend", ScoutSdkUi.getImage("default.gif"), buttonType.getField("SYSTEM_TYPE_WIZARD_SUSPEND"), 10)};
            Arrays.sort(this.m_buttonSystemTypeProposals, new ContentProposalExComparator(false));
        }
        return this.m_buttonSystemTypeProposals;
    }

    public static ConstantFieldProposal<Integer>[] getFormDisplayHintProposals() {
        return instance.getFormDisplayHintProposalsImpl();
    }

    private ConstantFieldProposal<Integer>[] getFormDisplayHintProposalsImpl() {
        if (this.m_formDisplayHintProposals == null) {
            IType formType = ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
            this.m_formDisplayHintProposals = new ConstantFieldProposal[]{new ConstantFieldProposal<Integer>("Dialog", ScoutSdkUi.getImage("default.gif"), formType.getField("DISPLAY_HINT_DIALOG"), 0), new ConstantFieldProposal<Integer>("View", ScoutSdkUi.getImage("default.gif"), formType.getField("DISPLAY_HINT_VIEW"), 20)};
        }
        return this.m_formDisplayHintProposals;
    }

    public static ConstantFieldProposal<Integer>[] getVerticalAlignmentProposals() {
        return instance.getVerticalAlignmentProposalsImpl();
    }

    private ConstantFieldProposal<Integer>[] getVerticalAlignmentProposalsImpl() {
        if (this.m_verticalAlignmentProposals == null) {
            this.m_verticalAlignmentProposals = new ConstantFieldProposal[]{new ConstantFieldProposal<Integer>("Top", ScoutSdkUi.getImage("vertical_top.gif"), null, -1), new ConstantFieldProposal<Integer>("Center", ScoutSdkUi.getImage("vertical_center.gif"), null, 0), new ConstantFieldProposal<Integer>("Bottom", ScoutSdkUi.getImage("vertical_bottom.gif"), null, 1)};
        }
        return this.m_verticalAlignmentProposals;
    }

    public static ConstantFieldProposal<Integer>[] getHorizontalAlignmentProposals() {
        return instance.getHorizontalAlignmentProposalsImpl();
    }

    private ConstantFieldProposal<Integer>[] getHorizontalAlignmentProposalsImpl() {
        if (this.m_horizontalAlignmentProposals == null) {
            this.m_horizontalAlignmentProposals = new ConstantFieldProposal[]{new ConstantFieldProposal<Integer>("Left", ScoutSdkUi.getImage("horizontal_left.gif"), null, -1), new ConstantFieldProposal<Integer>("Center", ScoutSdkUi.getImage("horizontal_center.gif"), null, 0), new ConstantFieldProposal<Integer>("Right", ScoutSdkUi.getImage("horizontal_right.gif"), null, 1)};
        }
        return this.m_horizontalAlignmentProposals;
    }

    public static String getFieldName(IType field, String labelMethodName) {
        return ScoutSourceUtilities.getTranslatedMethodStringValue((IType)field, (String)labelMethodName);
    }

    public static ITypeProposal[] getPageShortListProposals() {
        return instance.getPageShortListProposalsImpl();
    }

    private ITypeProposal[] getPageShortListProposalsImpl() {
        if (this.m_pageShortListProposals == null) {
            this.m_pageShortListProposals = new ITypeProposal[]{new TypeProposal(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes")), new TypeProposal(ScoutSdk.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithTable"))};
        }
        return this.m_pageShortListProposals;
    }

    public static BundleTypeProposal[] getAllBundleProposals() {
        return instance.getAllBundleProposalsImpl();
    }

    private BundleTypeProposal[] getAllBundleProposalsImpl() {
        if (this.m_bundleTypes == null) {
            this.m_bundleTypes = new BundleTypeProposal[]{new BundleTypeProposal(2, "Client"), new BundleTypeProposal(256, "Client Test"), new BundleTypeProposal(128, "Client Swing"), new BundleTypeProposal(32, "Client SWT"), new BundleTypeProposal(4, "Shared"), new BundleTypeProposal(8, "Server"), new BundleTypeProposal(64, "RCP Application (SWT)"), new BundleTypeProposal(16, "Server Appliaction")};
        }
        return this.m_bundleTypes;
    }

    public static IconProposal[] getScoutIconProposals(Display display, IScoutBundle bundle) {
        return instance.getBCIconProposalsImpl(display, bundle);
    }

    private IconProposal[] getBCIconProposalsImpl(Display dispaly, IScoutBundle bundle) {
        if (this.m_projectImageRegistiry == null) {
            this.m_projectImageRegistiry = new ImageRegistry(dispaly);
        }
        IIconProvider iconProvider = bundle.findBestMatchIconProvider();
        ArrayList<IconProposal> proposals = new ArrayList<IconProposal>();
        ScoutIconDesc[] scoutIconDescArray = iconProvider.getIcons();
        int n = scoutIconDescArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutIconDesc icon = scoutIconDescArray[n2];
            Image img = this.m_projectImageRegistiry.get(icon.getId());
            if (img == null) {
                ImageDescriptor imageDescriptor = icon.getImageDescriptor();
                this.m_projectImageRegistiry.put(icon.getId(), imageDescriptor);
                img = this.m_projectImageRegistiry.get(icon.getId());
            }
            proposals.add(new IconProposal(icon, img));
            ++n2;
        }
        return proposals.toArray(new IconProposal[proposals.size()]);
    }

    public static class ContentProposalExComparator
    implements Comparator<IContentProposalEx> {
        private final boolean m_expertMode;

        public ContentProposalExComparator(boolean expertMode) {
            this.m_expertMode = expertMode;
        }

        @Override
        public int compare(IContentProposalEx o1, IContentProposalEx o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1 == null) {
                return 1;
            }
            return o1.getLabel(false, this.m_expertMode).compareTo(o2.getLabel(false, true));
        }
    }
}

