/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.swt.graphics.Image;

public class SignatureProposal
implements IContentProposalEx {
    private final String m_signature;
    private String m_simpleTypeName;
    private String m_fullyQuallifiedName;
    private String m_packageName;
    private boolean m_isPrimitive = false;

    public SignatureProposal(String signature) {
        this.m_signature = signature;
        this.m_isPrimitive = ScoutSdkUtility.getSignatureType((String)signature) == 2;
        this.m_simpleTypeName = ScoutSdkUtility.getSimpleTypeSignature((String)signature);
        if (!this.m_isPrimitive) {
            this.m_packageName = Signature.getSignatureQualifier((String)this.m_signature);
            this.m_fullyQuallifiedName = ScoutSdkUtility.getNonGenericSimpleName((String)this.m_signature);
        }
    }

    @Override
    public int getCursorPosition(boolean selected, boolean expertMode) {
        return this.m_simpleTypeName.length();
    }

    @Override
    public Image getImage(boolean selected, boolean expertMode) {
        Image img = null;
        img = ScoutSdkUi.getImage("field_public_obj.gif");
        return img;
    }

    @Override
    public String getLabel(boolean selected, boolean expertMode) {
        if (this.m_isPrimitive) {
            return this.getPrimitiveLabel(selected, expertMode);
        }
        return this.getTypeLabel(selected, expertMode);
    }

    private String getPrimitiveLabel(boolean selected, boolean expertMode) {
        String label = this.m_simpleTypeName;
        return label;
    }

    private String getTypeLabel(boolean selected, boolean expertMode) {
        String name = "";
        String packagePostfix = "";
        if (expertMode) {
            name = this.m_simpleTypeName;
            packagePostfix = "  (" + this.m_packageName + ")";
        } else {
            name = this.m_simpleTypeName;
            packagePostfix = "  (" + this.m_fullyQuallifiedName + ")";
        }
        if (selected) {
            name = String.valueOf(name) + packagePostfix;
        }
        return name;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public int hashCode() {
        return this.getSignature().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SignatureProposal) {
            SignatureProposal comp = (SignatureProposal)obj;
            return this.getSignature().equals(comp.getSignature());
        }
        return false;
    }
}

