/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.core.search.TypeDeclarationMatch;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.ISeparatorProposal;
import org.eclipse.scout.sdk.ui.fields.proposal.SignatureProposal;
import org.eclipse.swt.graphics.Image;

public class SignatureProposalProvider
implements IContentProposalProvider {
    private static final IContentProposalEx[] m_primitives = new IContentProposalEx[]{new SignatureProposal("Z"), new SignatureProposal("I"), new SignatureProposal("D"), new SignatureProposal("B")};
    private static final IContentProposalEx[] m_simpleList = new IContentProposalEx[]{new SignatureProposal(Signature.createTypeSignature((String)ArrayList.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Boolean.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Collection.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Date.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Double.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Enumeration.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Float.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)HashMap.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Integer.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)List.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Long.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Map.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Number.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Object.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Runnable.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Set.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)String.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)TreeMap.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)TreeSet.class.getName(), (boolean)true)), new SignatureProposal(Signature.createTypeSignature((String)Vector.class.getName(), (boolean)true))};
    private SearchEngine m_searchEngine;
    private final boolean m_usePrimitives;
    private final boolean m_supportsGenerics;
    private final IJavaSearchScope m_searchScope;

    public SignatureProposalProvider(IJavaSearchScope searchScope, boolean usePrimitives, boolean supportsGenerics) {
        this.m_searchScope = searchScope;
        this.m_usePrimitives = usePrimitives;
        this.m_supportsGenerics = supportsGenerics;
        this.m_searchEngine = new SearchEngine();
    }

    @Override
    public boolean supportsExpertMode() {
        return true;
    }

    @Override
    public IContentProposalEx[] getProposals(String content, int cursorPosition, IProgressMonitor monitor) {
        IContentProposalEx prop;
        int n;
        int n2;
        IContentProposalEx[] iContentProposalExArray;
        ArrayList<IContentProposalEx> props = new ArrayList<IContentProposalEx>();
        String patStr = String.valueOf(content.substring(0, cursorPosition)) + "*";
        char[] pattern = CharOperation.toLowerCase((char[])patStr.toCharArray());
        if (this.m_usePrimitives) {
            iContentProposalExArray = m_primitives;
            n2 = m_primitives.length;
            n = 0;
            while (n < n2) {
                prop = iContentProposalExArray[n];
                if (CharOperation.match((char[])pattern, (char[])prop.getLabel(false, false).toCharArray(), (boolean)false)) {
                    props.add(prop);
                }
                ++n;
            }
        }
        iContentProposalExArray = m_simpleList;
        n2 = m_simpleList.length;
        n = 0;
        while (n < n2) {
            prop = iContentProposalExArray[n];
            if (CharOperation.match((char[])pattern, (char[])prop.getLabel(false, false).toCharArray(), (boolean)false)) {
                props.add(prop);
            }
            ++n;
        }
        return props.toArray(new IContentProposalEx[props.size()]);
    }

    @Override
    public IContentProposalEx[] getProposalsExpertMode(String contents, int position, IProgressMonitor monitor) {
        ArrayList<IContentProposalEx> collector = new ArrayList<IContentProposalEx>();
        if (this.m_usePrimitives) {
            this.collectPrimitivProposals(contents, position, collector);
        }
        this.collectTypes(contents, position, collector, monitor);
        return collector.toArray(new IContentProposalEx[collector.size()]);
    }

    private void collectPrimitivProposals(String contents, int position, ArrayList<IContentProposalEx> collector) {
        String prefix = contents.substring(0, position);
        IContentProposalEx[] iContentProposalExArray = m_primitives;
        int n = m_primitives.length;
        int n2 = 0;
        while (n2 < n) {
            IContentProposalEx prop = iContentProposalExArray[n2];
            if (prop.getLabel(false, true).startsWith(prefix)) {
                collector.add(prop);
            }
            ++n2;
        }
    }

    private void collectTypes(String contents, int position, ArrayList<IContentProposalEx> collector, IProgressMonitor monitor) {
        P_SearchRequestor searchRequestor;
        block7: {
            if (position < 1) {
                return;
            }
            searchRequestor = new P_SearchRequestor(monitor);
            try {
                this.m_searchEngine.search(SearchPattern.createPattern((String)(String.valueOf(contents.substring(0, position)) + "*"), (int)0, (int)0, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, this.m_searchScope, (SearchRequestor)searchRequestor, null);
            }
            catch (CoreException e) {
                if (e.getStatus().matches(4)) {
                    ScoutSdkUi.logWarning(e);
                    return;
                }
                if (!e.getStatus().matches(8)) break block7;
                return;
            }
        }
        ArrayList<IContentProposalEx> props = new ArrayList<IContentProposalEx>(searchRequestor.getResult());
        if (props.get(0) instanceof ISeparatorProposal) {
            props.remove(0);
        } else if (props.get(props.size() - 1) instanceof ISeparatorProposal) {
            props.remove(props.size() - 1);
        }
        collector.addAll(props);
    }

    private class P_SearchRequestor
    extends SearchRequestor {
        private IProgressMonitor m_monitor;
        private TreeMap<CompositeObject, IContentProposalEx> m_foundTypes = new TreeMap();
        private int counter = 0;

        public P_SearchRequestor(IProgressMonitor monitor) {
            this.m_monitor = monitor;
            this.m_foundTypes.put(new CompositeObject(new Object[]{"B"}), new P_Separator());
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (this.m_monitor.isCanceled()) {
                throw new CoreException((IStatus)new Status(8, "org.eclipse.scout.sdk", "canceled by monitor"));
            }
            if (match instanceof TypeDeclarationMatch) {
                IType type = (IType)match.getElement();
                if (!SignatureProposalProvider.this.m_supportsGenerics && type.getTypeParameters().length > 0) {
                    return;
                }
                this.m_foundTypes.put(new CompositeObject(new Object[]{"A", type.getElementName(), type.getFullyQualifiedName()}), new SignatureProposal(Signature.createTypeSignature((String)type.getFullyQualifiedName(), (boolean)true)));
                if (this.counter++ > 98) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.scout.sdk", "stopped after 100"));
                }
            }
        }

        public Collection<IContentProposalEx> getResult() {
            return this.m_foundTypes.values();
        }

        private class P_Separator
        implements ISeparatorProposal {
            private P_Separator() {
            }

            @Override
            public String getLabel(boolean selected, boolean expertMode) {
                return "------------ common used ------------------";
            }

            @Override
            public Image getImage(boolean selected, boolean expertMode) {
                return ScoutSdkUi.getImage("type_separator.gif");
            }

            @Override
            public int getCursorPosition(boolean selected, boolean expertMode) {
                return 0;
            }
        }
    }
}

