/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.proposal.ITypeProposal;
import org.eclipse.swt.graphics.Image;

public class TypeProposal
implements ITypeProposal {
    private final String m_simpleName;
    private final String m_fullyQualifiedName;
    private final String m_packageName;
    private IType m_type;

    public TypeProposal(String fullyQuallifiedName) {
        this(fullyQuallifiedName.substring(fullyQuallifiedName.lastIndexOf(".") + 1), fullyQuallifiedName, fullyQuallifiedName.substring(0, fullyQuallifiedName.lastIndexOf(".")));
    }

    public TypeProposal(IType type) {
        this(type.getElementName(), type.getFullyQualifiedName(), type.getPackageFragment().getElementName());
        this.m_type = type;
    }

    public TypeProposal(String simpleName, String fullyQualifiedName, String packageName) {
        this.m_simpleName = simpleName;
        this.m_fullyQualifiedName = fullyQualifiedName;
        this.m_packageName = packageName;
    }

    @Override
    public int getProposalType() {
        return 1;
    }

    @Override
    public String getLabel(boolean selected, boolean expertMode) {
        String name = "";
        String packagePostfix = "";
        if (expertMode) {
            name = this.getSimpleName();
            packagePostfix = "  (" + this.getPackageName() + ")";
        } else {
            name = this.getSimpleName();
            packagePostfix = "  (" + this.getFullyQualifiedName() + ")";
        }
        if (selected) {
            name = String.valueOf(name) + packagePostfix;
        }
        return name;
    }

    @Override
    public Image getImage(boolean selected, boolean expertMode) {
        Image img = null;
        img = ScoutSdkUi.getImage("field_public_obj.gif");
        return img;
    }

    @Override
    public int getCursorPosition(boolean selected, boolean expertMode) {
        if (expertMode) {
            return this.getSimpleName().length();
        }
        return this.getSimpleName().length();
    }

    public String getFullyQualifiedName() {
        return this.m_fullyQualifiedName;
    }

    public String getSimpleName() {
        return this.m_simpleName;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    @Override
    public IType getType() {
        if (this.m_type == null) {
            this.m_type = ScoutSdk.getType((String)this.getFullyQualifiedName());
        }
        return this.m_type;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeProposal) {
            return CompareUtility.equals((Object)((TypeProposal)obj).getType(), (Object)this.getType());
        }
        return false;
    }
}

