/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.table;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class AutoResizeColumnTable
extends Table {
    public static final String COLUMN_WEIGHT = "columnWeight";
    private boolean m_autoResizeColumns;
    private Listener m_autoResizeListener = new Listener(){

        public void handleEvent(Event event) {
            AutoResizeColumnTable.this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AutoResizeColumnTable.this.handleAutoSizeColumns();
                }
            });
        }
    };

    public AutoResizeColumnTable(Composite parent, int style) {
        super(parent, style);
        this.setAutoResizeColumns(true);
    }

    protected void checkSubclass() {
    }

    public void setAutoResizeColumns(boolean autoResizeColumns) {
        this.m_autoResizeColumns = autoResizeColumns;
        if (autoResizeColumns) {
            this.addListener(11, this.m_autoResizeListener);
        } else {
            this.removeListener(11, this.m_autoResizeListener);
        }
    }

    public boolean isAutoResizeColumns() {
        return this.m_autoResizeColumns;
    }

    protected void handleAutoSizeColumns() {
        if (!this.isDisposed()) {
            int totalWidth = this.getClientArea().width;
            if (this.getVerticalBar() != null) {
                this.getVerticalBar().getVisible();
            }
            int totalWeight = 0;
            HashMap<TableColumn, Integer> columnWeights = new HashMap<TableColumn, Integer>();
            TableColumn[] tableColumnArray = this.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                if (col != null && !col.isDisposed()) {
                    Object colWeightData = col.getData(COLUMN_WEIGHT);
                    if (colWeightData == null) {
                        ScoutSdkUi.logWarning("auto resizable table, contains columns with no weights setted!");
                    } else {
                        Integer colWeight = (Integer)colWeightData;
                        columnWeights.put(col, colWeight);
                        totalWeight += colWeight.intValue();
                    }
                }
                ++n2;
            }
            double factor = (double)totalWidth / (double)totalWeight;
            if (factor < 1.0) {
                factor = 1.0;
            }
            int i = 0;
            for (Map.Entry entry : columnWeights.entrySet()) {
                if (i < columnWeights.size() - 1) {
                    int width = (int)(factor * (double)((Integer)entry.getValue()).intValue());
                    ((TableColumn)entry.getKey()).setWidth(width);
                    totalWidth -= width;
                    continue;
                }
                ((TableColumn)entry.getKey()).setWidth(totalWidth);
            }
        }
    }
}

