/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.table;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.table.AutoResizeColumnTable;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;

public class FilteredTable
extends Composite {
    private Text m_filterField;
    private Button m_clearFilter;
    private TableViewer m_tableViewer;
    private Table m_table;
    private P_TableFilter m_tableFilter;
    private final int m_style;

    public FilteredTable(Composite parent, int style) {
        super(parent, 0);
        this.m_style = style;
        this.m_tableFilter = new P_TableFilter();
        GridLayout layout = new GridLayout(1, true);
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.createContent(this);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point computeSize = super.computeSize(wHint, hHint, changed);
        return computeSize;
    }

    protected void createContent(Composite parent) {
        Control filterControl = this.createFilterControl(parent);
        this.m_table = new AutoResizeColumnTable(parent, this.m_style);
        this.m_tableViewer = new TableViewer(this.m_table);
        this.m_tableViewer.setFilters(new ViewerFilter[]{this.m_tableFilter});
        this.m_tableViewer.setSorter((ViewerSorter)new P_TableSorter());
        filterControl.setLayoutData((Object)new GridData(768));
        this.m_table.setLayoutData((Object)new GridData(1808));
    }

    private Control createFilterControl(Composite parent) {
        Composite filterComposite = new Composite(parent, 0);
        this.m_filterField = new Text(filterComposite, 2048);
        this.m_filterField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilteredTable.this.m_tableFilter.setFilterText(FilteredTable.this.m_filterField.getText());
                FilteredTable.this.refresh(true);
                GridData buttonData = (GridData)FilteredTable.this.m_clearFilter.getLayoutData();
                if (StringUtility.isNullOrEmpty((String)FilteredTable.this.m_filterField.getText())) {
                    buttonData.exclude = true;
                    FilteredTable.this.m_clearFilter.setEnabled(false);
                } else {
                    buttonData.exclude = false;
                    FilteredTable.this.m_clearFilter.setEnabled(true);
                }
                FilteredTable.this.m_filterField.getParent().layout(true);
            }
        });
        this.m_filterField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    FilteredTable.this.m_table.setFocus();
                }
            }
        });
        this.m_clearFilter = new Button(filterComposite, 524296);
        this.m_clearFilter.setImage(ScoutSdkUi.getImage("delete.gif"));
        this.m_clearFilter.setEnabled(false);
        this.m_clearFilter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredTable.this.m_filterField.setText("");
                FilteredTable.this.m_filterField.setFocus();
            }
        });
        filterComposite.setTabList(new Control[]{this.m_filterField});
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        filterComposite.setLayout((Layout)layout);
        this.m_filterField.setLayoutData((Object)new GridData(768));
        GridData clearFieldData = new GridData(20, 20);
        clearFieldData.horizontalIndent = 3;
        clearFieldData.exclude = true;
        this.m_clearFilter.setLayoutData((Object)clearFieldData);
        return filterComposite;
    }

    public void refresh(boolean selectFirst) {
        this.m_tableViewer.refresh();
        if (selectFirst) {
            StructuredSelection selection = new StructuredSelection();
            if (this.m_tableViewer.getTable().getItemCount() > 0) {
                Object data = this.m_table.getItem(0).getData();
                selection = new StructuredSelection(data);
            }
            this.m_tableViewer.setSelection((ISelection)selection);
        }
    }

    public Table getTable() {
        return this.m_table;
    }

    public TableViewer getViewer() {
        return this.m_tableViewer;
    }

    public void setEnabled(boolean enabled) {
        this.m_table.setEnabled(enabled);
        this.m_filterField.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public boolean isEnabled() {
        if (this.m_table.getEnabled() && this.m_filterField.getEnabled()) {
            return super.isEnabled();
        }
        return false;
    }

    public boolean getEnabled() {
        return this.m_table.getEnabled() && this.m_filterField.getEnabled();
    }

    private class P_TableFilter
    extends ViewerFilter {
        private String m_filterString = "*";

        private P_TableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            ITableLabelProvider labelProvider = (ITableLabelProvider)((TableViewer)viewer).getLabelProvider();
            String columnText = labelProvider.getColumnText(element, 0);
            return !StringUtility.isNullOrEmpty((String)columnText) && CharOperation.match((char[])this.m_filterString.toCharArray(), (char[])columnText.toCharArray(), (boolean)false);
        }

        public void setFilterText(String filterText) {
            if (StringUtility.isNullOrEmpty((String)filterText)) {
                filterText = "*";
            }
            if (!filterText.endsWith("*")) {
                filterText = String.valueOf(filterText) + "*";
            }
            this.m_filterString = filterText.toLowerCase();
        }
    }

    private class P_TableSorter
    extends ViewerSorter {
        private P_TableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IBaseLabelProvider provider = FilteredTable.this.getViewer().getLabelProvider();
            if (provider instanceof ITableLabelProvider) {
                ITableLabelProvider labelProvider = (ITableLabelProvider)provider;
                return labelProvider.getColumnText(e1, 0).compareTo(labelProvider.getColumnText(e2, 0));
            }
            return -1;
        }
    }
}

