/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.table;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.swt.graphics.Image;

public class JavaElementTableContentProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private IJavaElement[] m_elements = new IJavaElement[0];

    public void setElements(IJavaElement[] elements) {
        this.m_elements = elements;
    }

    public IJavaElement[] getElements() {
        return this.m_elements;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_elements;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image img = null;
        if (columnIndex == 0) {
            try {
                switch (((IJavaElement)element).getElementType()) {
                    case 7: {
                        if (((IType)element).isInterface()) {
                            img = ScoutSdkUi.getImage("innerinterface_obj.gif");
                            break;
                        }
                        img = ScoutSdkUi.getImage("class_obj.gif");
                        break;
                    }
                    case 9: {
                        img = ScoutSdkUi.getImage("public_co.gif");
                        break;
                    }
                    case 8: {
                        img = ScoutSdkUi.getImage("field_private_obj.gif");
                        break;
                    }
                    default: {
                        img = ScoutSdkUi.getImage("default.gif");
                        break;
                    }
                }
            }
            catch (JavaModelException e) {
                ScoutSdkUi.logWarning(e);
            }
        }
        return img;
    }

    public String getColumnText(Object element, int columnIndex) {
        IJavaElement member = (IJavaElement)element;
        switch (columnIndex) {
            case 0: {
                return member.getElementName();
            }
            case 1: {
                if (member.getElementType() == 7) {
                    return ((IType)member).getPackageFragment().getElementName();
                }
                if (member.getElementType() != 9) break;
                return ((IMethod)member).getDeclaringType().getFullyQualifiedName();
            }
        }
        return "";
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

