/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.tooltip;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractTooltip {
    private Point m_mouseLocation;
    private Control m_sourceControl;
    private CloseJob m_closeJob = new CloseJob();
    private P_PopupListener m_listener;
    private Shell m_shell;
    private Object m_lock = new Object();

    public Control getSourceControl() {
        return this.m_sourceControl;
    }

    public AbstractTooltip(Control sourceControl) {
        this.m_sourceControl = sourceControl;
        this.attachListeners();
        this.m_sourceControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AbstractTooltip.this.detachListeners();
            }
        });
    }

    private void attachListeners() {
        if (this.m_listener == null) {
            this.m_listener = new P_PopupListener();
        }
        this.m_sourceControl.addListener(7, (Listener)this.m_listener);
        this.m_sourceControl.addListener(12, (Listener)this.m_listener);
        this.m_sourceControl.addListener(1, (Listener)this.m_listener);
        this.m_sourceControl.addListener(3, (Listener)this.m_listener);
        this.m_sourceControl.addListener(5, (Listener)this.m_listener);
        this.m_sourceControl.addListener(32, (Listener)this.m_listener);
        this.m_sourceControl.addListener(16, (Listener)this.m_listener);
    }

    private void detachListeners() {
        if (this.m_listener != null) {
            this.m_sourceControl.getShell().removeListener(27, (Listener)this.m_listener);
            this.m_sourceControl.removeListener(7, (Listener)this.m_listener);
            this.m_sourceControl.removeListener(12, (Listener)this.m_listener);
            this.m_sourceControl.removeListener(1, (Listener)this.m_listener);
            this.m_sourceControl.removeListener(3, (Listener)this.m_listener);
            this.m_sourceControl.removeListener(5, (Listener)this.m_listener);
            this.m_sourceControl.removeListener(32, (Listener)this.m_listener);
            this.m_sourceControl.removeListener(16, (Listener)this.m_listener);
            this.m_listener = null;
        }
    }

    protected abstract void createContent(Composite var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void show(int x, int y) {
        Shell[] shells = this.getSourceControl().getShell().getShells();
        if (shells.length > 0) {
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell s = shellArray[n2];
                if (s != null && s.isVisible()) {
                    return;
                }
                ++n2;
            }
        }
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_shell == null) {
                this.m_shell = new Shell(this.m_sourceControl.getShell(), 540676);
                this.m_shell.setBackground(this.m_shell.getDisplay().getSystemColor(29));
                GridLayout shellLayout = new GridLayout(1, true);
                this.m_shell.setLayout((Layout)shellLayout);
                this.createContent((Composite)this.m_shell);
            }
            this.m_mouseLocation = new Point(x, y);
            this.m_shell.pack();
            this.m_shell.setBounds(this.computeBounds(this.m_shell.getSize()));
            this.m_shell.setVisible(true);
            this.handleContentListeners((Composite)this.m_shell, true);
            this.m_shell.getParent().addListener(27, (Listener)this.m_listener);
        }
    }

    private void handleContentListeners(Composite content, boolean add) {
        if (add) {
            content.addListener(7, (Listener)this.m_listener);
        } else {
            content.removeListener(7, (Listener)this.m_listener);
        }
        Control[] controlArray = content.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                this.handleContentListeners((Composite)c, add);
            } else if (add) {
                c.addListener(7, (Listener)this.m_listener);
            } else {
                c.removeListener(7, (Listener)this.m_listener);
            }
            ++n2;
        }
    }

    private Rectangle computeBounds(Point shellSize) {
        Rectangle displayBounds = this.m_shell.getDisplay().getBounds();
        Rectangle sourceControlBounds = this.m_shell.getDisplay().map(this.m_sourceControl, null, this.m_sourceControl.getBounds());
        Rectangle bounds = new Rectangle(sourceControlBounds.x, sourceControlBounds.y + sourceControlBounds.height + 5, shellSize.x, shellSize.y);
        if (bounds.x + bounds.width > displayBounds.width) {
            bounds.x = sourceControlBounds.x + sourceControlBounds.y - shellSize.y;
        }
        if (bounds.y + bounds.height > displayBounds.height) {
            bounds.y = sourceControlBounds.y - shellSize.y - 5;
        }
        return bounds;
    }

    private void closeDelayed() {
        if (this.m_closeJob != null) {
            this.m_closeJob.cancel();
            this.m_closeJob.schedule(400L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_shell != null && !this.m_shell.isDisposed()) {
                Point cursorLocation = this.m_shell.getDisplay().getCursorLocation();
                Rectangle tooltipBounds = this.m_shell.getBounds();
                if (!tooltipBounds.contains(cursorLocation)) {
                    this.m_shell.removeListener(7, (Listener)this.m_listener);
                    this.handleContentListeners((Composite)this.m_shell, false);
                    this.m_shell.close();
                    this.m_shell = null;
                }
            }
        }
    }

    private void mouseMoved(int x, int y) {
    }

    private class CloseJob
    extends Job {
        public CloseJob() {
            super("close tooltip");
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(50);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (AbstractTooltip.this.m_shell != null && !AbstractTooltip.this.m_shell.isDisposed()) {
                AbstractTooltip.this.m_shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        AbstractTooltip.this.close();
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    private class P_PopupListener
    implements Listener {
        private P_PopupListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 32: {
                    AbstractTooltip.this.show(event.x, event.y);
                    break;
                }
                case 1: 
                case 3: 
                case 7: 
                case 12: 
                case 27: {
                    AbstractTooltip.this.closeDelayed();
                }
            }
        }
    }
}

