/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.tooltip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementLinks;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.fields.tooltip.AbstractTooltip;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class JavadocTooltip
extends AbstractTooltip {
    private IMember m_member;
    private Browser m_browser;
    private String m_javaDoc;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;

    public JavadocTooltip(Control sourceControl) {
        this(sourceControl, null);
    }

    public JavadocTooltip(Control sourceControl, IMember element) {
        super(sourceControl);
        this.m_member = element;
    }

    public void setMember(IMember member) {
        this.m_member = member;
        if (TypeUtility.exists((IJavaElement)this.m_member)) {
            this.computJavadoc();
        }
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_browser = new Browser(parent, 0);
        this.m_browser.setJavascriptEnabled(true);
        this.m_browser.setText(this.m_javaDoc);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 150;
        layoutData.widthHint = 500;
        this.m_browser.setLayoutData((Object)layoutData);
        this.m_browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                event.doit = false;
            }
        });
    }

    @Override
    protected void show(int x, int y) {
        if (!StringUtility.isNullOrEmpty((String)this.m_javaDoc)) {
            super.show(x, y);
        }
    }

    private void computJavadoc() {
        Job j = new Job("calculating java doc of '" + this.m_member.getElementName() + "'"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Reader contentReader = JavadocContentAccess.getHTMLContentReader((IMember)JavadocTooltip.this.m_member, (boolean)true, (boolean)true);
                    if (contentReader != null) {
                        JavadocTooltip.this.m_javaDoc = JavadocTooltip.this.getJavadocHtml(new IJavaElement[]{JavadocTooltip.this.m_member});
                        if (JavadocTooltip.this.getSourceControl() != null && !JavadocTooltip.this.getSourceControl().isDisposed()) {
                            JavadocTooltip.this.getSourceControl().getDisplay().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (JavadocTooltip.this.m_browser != null && !JavadocTooltip.this.m_browser.isDisposed()) {
                                        JavadocTooltip.this.m_browser.setText(JavadocTooltip.this.m_javaDoc);
                                    }
                                }
                            });
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        };
        j.setPriority(50);
        j.setSystem(true);
        j.setUser(false);
        j.schedule();
    }

    private String getJavadocHtml(IJavaElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        String base = null;
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember || curr.getElementType() == 14) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)this.getInfoText(curr, null, false));
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                IMember member = (IMember)curr;
                String constantValue = null;
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText((IJavaElement)member, constantValue, true));
                StringReader reader = null;
                try {
                    String content = JavadocContentAccess2.getHTMLContent((IMember)member, (boolean)true);
                    StringReader stringReader = reader = content == null ? null : new StringReader(content);
                    if (reader == null && member.isBinary()) {
                        boolean hasSource;
                        boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation((IJavaElement)member) != null;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)member.getAncestor(3);
                        boolean hasAttachedSource = root != null && root.getSourceAttachmentPath() != null;
                        IOpenable openable = member.getOpenable();
                        boolean bl = hasSource = openable.getBuffer() != null;
                        if (!hasAttachedSource && !hasAttachedJavadoc) {
                            reader = new StringReader("");
                        } else if (!hasAttachedJavadoc && !hasSource) {
                            reader = new StringReader("");
                        } else if (!hasAttachedSource) {
                            reader = new StringReader("");
                        } else if (!hasSource) {
                            reader = new StringReader("");
                        }
                    } else {
                        base = JavaDocLocations.getBaseURL((IMember)member);
                    }
                }
                catch (JavaModelException ex) {
                    JavaPlugin.log((IStatus)ex.getStatus());
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
            } else if (curr.getElementType() == 14 || curr.getElementType() == 15) {
                HTMLPrinter.addSmallHeader((StringBuffer)buffer, (String)this.getInfoText(curr, null, true));
            }
        }
        boolean flushContent = true;
        if (buffer.length() > 0 || flushContent) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, null, null, (String)JavadocTooltip.loadStyleSheet());
            if (base != null) {
                int endHeadIdx = buffer.indexOf("</head>");
                buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IJavaElement member, String constantValue, boolean allowImage) {
        StringBuffer label = new StringBuffer(JavaElementLinks.getElementLabel((IJavaElement)member, (long)LABEL_FLAGS));
        if (member.getElementType() == 8 && constantValue != null) {
            label.append(constantValue);
        }
        String imageName = null;
        try {
            URL imageUrl;
            if (allowImage && (imageUrl = JavaPlugin.getDefault().getImagesOnFSRegistry().getImageURL(member)) != null) {
                imageName = imageUrl.toExternalForm();
            }
        }
        catch (Exception exception) {
            ScoutSdkUi.logWarning("could not load image for '" + member.getElementName() + "'.");
        }
        return this.addImageAndLabel(member, imageName, label.toString());
    }

    private String addImageAndLabel(IJavaElement member, String imageName, String label) {
        StringBuffer buffer = new StringBuffer();
        Version frameworkVersion = new Version(ScoutSdkUi.getDefault().getBundle().getBundleContext().getProperty("osgi.framework.version"));
        if (frameworkVersion.getMajor() == 3) {
            if (frameworkVersion.getMinor() <= 5) {
                try {
                    Method method = JavadocHover.class.getMethod("addImageAndLabel", StringBuffer.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE);
                    method.invoke(null, buffer, imageName, 16, 16, 8, 5, label, 22, 0);
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("could not access method 'addImageAndLabel' on 'JavaHoover'.", e);
                }
            } else if (frameworkVersion.getMinor() <= 6) {
                try {
                    Method method = JavadocHover.class.getMethod("addImageAndLabel", StringBuffer.class, String.class, Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE);
                    method.invoke(null, buffer, imageName, 16, 16, label, 22, 0);
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("could not access method 'addImageAndLabel' on 'JavaHoover'.", e);
                }
            } else {
                try {
                    Method method = JavadocHover.class.getMethod("addImageAndLabel", StringBuffer.class, IJavaElement.class, String.class, Integer.TYPE, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE);
                    method.invoke(null, buffer, member, imageName, 16, 16, label, 22, 0);
                }
                catch (Exception e) {
                    ScoutSdkUi.logError("could not access method 'addImageAndLabel' on 'JavaHoover'.", e);
                }
            }
        }
        return buffer.toString();
    }

    /*
     * Loose catch block
     */
    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return null;
        }
        BufferedReader reader = null;
        reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
        StringBuffer buffer = new StringBuffer(1500);
        String line = reader.readLine();
        while (line != null) {
            buffer.append(line);
            buffer.append('\n');
            line = reader.readLine();
        }
        FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
        String string = HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (IOException iOException) {}
        return string;
        catch (IOException ex) {
            try {
                JavaPlugin.log((Throwable)ex);
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
            return null;
        }
    }
}

