/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.ICodeIdProvider;
import org.eclipse.scout.sdk.workspace.IScoutProject;

public final class CodeIdExtensionPoint {
    private static Object bsiCaseExtensionsCacheLock = new Object();
    private static Object codeIdProviderExtensionsCacheLock = new Object();
    private static ICodeIdProvider[] codeIdProviderExtensions;

    private CodeIdExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ICodeIdProvider[] getCodeIdProviderExtensions() {
        Object object = codeIdProviderExtensionsCacheLock;
        synchronized (object) {
            IExtension[] extensions;
            TreeMap<CompositeObject, ICodeIdProvider> providers = new TreeMap<CompositeObject, ICodeIdProvider>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", "scoutCodeIdProvider");
            IExtension[] iExtensionArray = extensions = xp.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] serviceElememts = extension.getConfigurationElements();
                int i = 0;
                while (i < serviceElememts.length) {
                    IConfigurationElement serviceElememt = serviceElememts[i];
                    String className = serviceElememt.getAttribute("class");
                    int priority = 0;
                    try {
                        String prio = serviceElememt.getAttribute("priority");
                        priority = Integer.parseInt(prio);
                    }
                    catch (Exception e) {
                        ScoutSdkUi.logWarning("could not parse priority of CodeIdProvider extension '" + serviceElememt.getName() + "'", e);
                    }
                    ScoutSdkUi.logInfo("found service: " + className);
                    try {
                        ICodeIdProvider service = (ICodeIdProvider)serviceElememt.createExecutableExtension("class");
                        providers.put(new CompositeObject(new Object[]{priority, i, service}), service);
                    }
                    catch (Throwable t) {
                        ScoutSdkUi.logError("register service: " + className, t);
                    }
                    ++i;
                }
                ++n2;
            }
            codeIdProviderExtensions = providers.values().toArray(new ICodeIdProvider[providers.size()]);
        }
        return codeIdProviderExtensions;
    }

    public static String getNextCodeId(IScoutProject projectGroup, String genericSignature) {
        ICodeIdProvider[] providers;
        String value = null;
        ICodeIdProvider[] iCodeIdProviderArray = providers = CodeIdExtensionPoint.getCodeIdProviderExtensions();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            ICodeIdProvider p = iCodeIdProviderArray[n2];
            try {
                value = p.getNextId(projectGroup, genericSignature);
                if (value != null) {
                    break;
                }
            }
            catch (Exception e) {
                ScoutSdkUi.logWarning("Exception in codeIdExtension '" + p.getClass().getName() + "'", e);
            }
            ++n2;
        }
        return value;
    }
}

