/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.IDragSourceDelegator;
import org.eclipse.scout.sdk.ui.extensions.IDropTargetDelegator;

public class DndExtensionPoint {
    private static final String dropDelegatorAttName = "dropTargetDelegator";
    private static final String dragDelegatorAttName = "dragSourceDelegator";
    private static DndExtensionPoint instance = new DndExtensionPoint();
    private List<IDragSourceDelegator> m_dragSourceDelegators;
    private List<IDropTargetDelegator> m_dropTargetDelegators;

    private DndExtensionPoint() {
        this.init();
    }

    private void init() {
        IExtension[] extensions;
        ArrayList<IDragSourceDelegator> dragDelegators = new ArrayList<IDragSourceDelegator>();
        ArrayList<IDropTargetDelegator> dropDelegators = new ArrayList<IDropTargetDelegator>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", "outlineDragAndDrop");
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    if (element.getAttribute(dragDelegatorAttName) != null) {
                        IDragSourceDelegator dragDelegator = (IDragSourceDelegator)element.createExecutableExtension(dragDelegatorAttName);
                        dragDelegators.add(dragDelegator);
                    } else if (element.getAttribute(dropDelegatorAttName) != null) {
                        IDropTargetDelegator dropDelegator = (IDropTargetDelegator)element.createExecutableExtension(dropDelegatorAttName);
                        dropDelegators.add(dropDelegator);
                    }
                }
                catch (CoreException coreException) {
                    ScoutSdkUi.logError("could not create an executable extension of point '" + extension.getExtensionPointUniqueIdentifier() + "'.");
                }
                ++n4;
            }
            ++n2;
        }
        this.m_dropTargetDelegators = dropDelegators;
        this.m_dragSourceDelegators = dragDelegators;
    }

    public static IDragSourceDelegator[] getDragSourceDelegators() {
        return instance.getDragSourceDelegatorsImpl();
    }

    private IDragSourceDelegator[] getDragSourceDelegatorsImpl() {
        return this.m_dragSourceDelegators.toArray(new IDragSourceDelegator[this.m_dragSourceDelegators.size()]);
    }

    public static IDropTargetDelegator[] getDropTargetDelegators() {
        return instance.getDropTargetDelegatorsImpl();
    }

    private IDropTargetDelegator[] getDropTargetDelegatorsImpl() {
        return this.m_dropTargetDelegators.toArray(new IDropTargetDelegator[this.m_dropTargetDelegators.size()]);
    }
}

