/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.codecompletion;

import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.scout.sdk.ScoutSdk;
import org.eclipse.scout.sdk.ScoutSdkUtility;
import org.eclipse.scout.sdk.jdt.JdtUtility;
import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.SqlBindProposal;
import org.eclipse.scout.sdk.workspace.type.ITypeFilter;
import org.eclipse.scout.sdk.workspace.type.TypeFilters;
import org.eclipse.scout.sdk.workspace.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.typecache.ITypeHierarchy;
import org.eclipse.swt.graphics.Image;

public class SqlBindCompletionProposalProcessor {
    final IType AbstractFormData = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData");
    final IType AbstractFormFieldData = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData");
    final IType AbstractPropertyData = ScoutSdk.getType((String)"org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData");
    private final Image m_image = ScoutSdkUi.getImage("default.gif");
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];
    private static final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];

    public ICompletionProposal[] computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            IType t;
            if (!this.isSqlStatementLocation(context.getViewer(), context.getInvocationOffset())) {
                return NO_PROPOSALS;
            }
            IType formData = this.getFormDataParameterType(context);
            if (formData == null || !formData.exists()) {
                return NO_PROPOSALS;
            }
            String prefix = this.getPrefix(context.getViewer(), context.getInvocationOffset());
            TreeMap<String, SqlBindProposal> result = new TreeMap<String, SqlBindProposal>();
            ITypeHierarchy hierarchy = ScoutSdk.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{formData});
            IType[] iTypeArray = TypeUtility.getInnerTypes((IType)formData, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)this.AbstractFormFieldData, (ITypeHierarchy)hierarchy));
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                t = iTypeArray[n2];
                if (t.getElementName().toLowerCase().startsWith(prefix.toLowerCase())) {
                    SqlBindProposal prop = new SqlBindProposal(t.getElementName(), prefix, context.getInvocationOffset(), this.m_image);
                    result.put(prop.getDisplayString(), prop);
                }
                ++n2;
            }
            iTypeArray = TypeUtility.getInnerTypes((IType)formData, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)this.AbstractPropertyData, (ITypeHierarchy)hierarchy));
            n = iTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                t = iTypeArray[n2];
                String propName = t.getElementName();
                if ((propName = propName.replaceAll("Property$", "")).toLowerCase().startsWith(prefix.toLowerCase())) {
                    SqlBindProposal prop = new SqlBindProposal(propName, prefix, context.getInvocationOffset(), this.m_image);
                    result.put(prop.getDisplayString(), prop);
                }
                ++n2;
            }
            return result.values().toArray(new ICompletionProposal[result.values().size()]);
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("error during creating sql copletion.", e);
            return NO_PROPOSALS;
        }
    }

    private boolean isSqlStatementLocation(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return false;
        }
        IRegion lineInfo = doc.getLineInformationOfOffset(offset);
        String linePart = doc.get(lineInfo.getOffset(), offset - lineInfo.getOffset());
        Matcher m = Pattern.compile("\\\"").matcher(linePart);
        boolean stringLocation = false;
        while (m.find()) {
            boolean bl = stringLocation = !stringLocation;
        }
        if (stringLocation) {
            stringLocation = linePart.matches(".*\\:[A-Za-z0-9_-]*$");
        }
        return stringLocation;
    }

    private IType getFormDataParameterType(JavaContentAssistInvocationContext context) throws JavaModelException {
        ICompilationUnit icu = context.getCompilationUnit();
        IJavaElement element = JdtUtility.findJavaElement((IJavaElement)icu, (int)context.getInvocationOffset(), (int)0);
        if (element.getElementType() == 9) {
            IMethod method = (IMethod)element;
            String[] stringArray = method.getParameterTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fqn;
                IType candidate;
                String parameter = stringArray[n2];
                String fqs = ScoutSdkUtility.getQuallifiedSignature((String)parameter, (IType)method.getDeclaringType());
                if (ScoutSdkUtility.getSignatureType((String)fqs) == 1 && (candidate = ScoutSdk.getType((String)(fqn = String.valueOf(Signature.getSignatureQualifier((String)fqs)) + "." + Signature.getSignatureSimpleName((String)fqs)))).newSupertypeHierarchy(null).contains(this.AbstractFormData)) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    private String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && Character.isLetterOrDigit(doc.getChar(offset))) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }
}

