/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.view.property;

import org.eclipse.scout.sdk.ui.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.extensions.view.property.IMultiPropertyViewPart;
import org.eclipse.scout.sdk.ui.extensions.view.property.ISinglePropertyViewPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;

public class PropertyViewExtension {
    private Class<? extends IPage> m_pageClass;
    private long m_singleViewPartRanking = Long.MIN_VALUE;
    private long m_multiViewPartRanking = Long.MIN_VALUE;
    private Class<? extends ISinglePropertyViewPart> m_singleViewPartClazz;
    private Class<? extends IMultiPropertyViewPart> m_multiViewPartClazz;

    public IMultiPropertyViewPart createMultiViewPart() {
        if (this.getSingleViewPartClazz() == null) {
            ScoutSdkUi.logWarning("view part is not defined");
            return null;
        }
        try {
            return this.getMultiViewPartClazz().newInstance();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not instansiate new view part '" + this.getSingleViewPartClazz().getName() + "'.", e);
            return null;
        }
    }

    public ISinglePropertyViewPart createSingleViewPart() {
        if (this.getSingleViewPartClazz() == null) {
            ScoutSdkUi.logWarning("view part is not defined");
            return null;
        }
        try {
            return this.getSingleViewPartClazz().newInstance();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not instansiate new view part '" + this.getSingleViewPartClazz().getName() + "'.", e);
            return null;
        }
    }

    public void setPageClass(Class<? extends IPage> pageClass) {
        this.m_pageClass = pageClass;
    }

    public Class<? extends IPage> getPageClass() {
        return this.m_pageClass;
    }

    public void setSingleViewPartClazz(Class<? extends ISinglePropertyViewPart> singleViewPartClazz, long ranking) {
        if (this.m_singleViewPartRanking < ranking) {
            this.m_singleViewPartClazz = singleViewPartClazz;
            this.m_singleViewPartRanking = ranking;
        }
    }

    public Class<? extends ISinglePropertyViewPart> getSingleViewPartClazz() {
        return this.m_singleViewPartClazz;
    }

    public void setMultiViewPartClazz(Class<? extends IMultiPropertyViewPart> multiViewPartClazz, long ranking) {
        if (this.m_multiViewPartRanking < ranking) {
            this.m_multiViewPartClazz = multiViewPartClazz;
            this.m_multiViewPartRanking = ranking;
        }
    }

    public Class<? extends IMultiPropertyViewPart> getMultiViewPartClazz() {
        return this.m_multiViewPartClazz;
    }
}

