/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.fields.proposal;

import org.eclipse.jdt.core.IField;
import org.eclipse.scout.sdk.ui.fields.proposal.AbstractContentProposalEx;
import org.eclipse.swt.graphics.Image;

public class ConstantFieldProposal<T>
extends AbstractContentProposalEx {
    private final IField m_field;
    private final T m_constantValue;

    public ConstantFieldProposal(String label, Image image, IField field, T constantValue) {
        super(label, image);
        this.m_field = field;
        this.m_constantValue = constantValue;
    }

    @Override
    public String getLabel(boolean selected, boolean expertMode) {
        if (selected && this.m_field != null) {
            return String.valueOf(this.getText()) + " (" + this.m_field.getElementName() + " = " + this.m_constantValue + " )";
        }
        return super.getLabel(selected, expertMode);
    }

    public IField getField() {
        return this.m_field;
    }

    public T getConstantValue() {
        return this.m_constantValue;
    }

    @Override
    public int hashCode() {
        long h = super.hashCode() ^ this.m_field.hashCode() ^ this.m_constantValue.hashCode();
        return (int)h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ConstantFieldProposal)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.compareTo((ConstantFieldProposal)obj) == 0;
    }

    public int compareTo(ConstantFieldProposal<?> o) {
        int c = super.compareTo(o);
        if (c != 0) {
            return c;
        }
        c = this.compareImpl(o.m_field, this.m_field);
        if (c != 0) {
            return c;
        }
        c = this.compareImpl(o.m_constantValue, this.m_constantValue);
        return c;
    }
}

