/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.fields.proposal;

import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.fields.proposal.AbstractContentProposalEx;
import org.eclipse.swt.graphics.Image;

public class JavaClassProposal
extends AbstractContentProposalEx {
    private final IType m_javaClass;

    public JavaClassProposal(String label, Image image, IType javaClass) {
        super(label, image);
        this.m_javaClass = javaClass;
    }

    public IType getJavaClass() {
        return this.m_javaClass;
    }

    @Override
    public String getLabel(boolean selected, boolean expertMode) {
        if (selected && this.m_javaClass != null) {
            return String.valueOf(this.getText()) + " (" + this.m_javaClass.getFullyQualifiedName() + ")";
        }
        return super.getLabel(selected, expertMode);
    }

    @Override
    public int hashCode() {
        long h = super.hashCode() ^ this.getJavaClass().hashCode();
        return (int)h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof JavaClassProposal)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.compareTo((JavaClassProposal)obj) == 0;
    }

    public int compareTo(JavaClassProposal o) {
        int c = super.compareTo(o);
        if (c != 0) {
            return c;
        }
        c = this.compareImpl(o.m_javaClass, this.m_javaClass);
        return c;
    }
}

