/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.fields.proposal.nls;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalEx;
import org.eclipse.scout.sdk.ui.fields.proposal.IContentProposalProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.NlsProposal;
import org.eclipse.scout.sdk.ui.internal.fields.proposal.nls.NlsNewProposal;

public class NlsTextProposalProvider
implements IContentProposalProvider {
    private NlsProposal[] m_proposals;

    public NlsTextProposalProvider() {
        this.m_proposals = new NlsProposal[0];
    }

    public NlsTextProposalProvider(INlsEntry[] entries, Language language) {
        this.setNlsEntries(entries, language);
    }

    public void setNlsEntries(INlsEntry[] entries, Language language) {
        TreeMap<CompositeObject, NlsProposal> proposals = new TreeMap<CompositeObject, NlsProposal>();
        INlsEntry[] iNlsEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            INlsEntry entry = iNlsEntryArray[n2];
            NlsProposal p = new NlsProposal(entry, language);
            proposals.put(new CompositeObject(new Object[]{p.getLabel(false, false), entry.getKey()}), p);
            ++n2;
        }
        this.m_proposals = proposals.values().toArray(new NlsProposal[proposals.size()]);
    }

    @Override
    public IContentProposalEx[] getProposals(String content, int cursorPosition, IProgressMonitor monitor) {
        ArrayList<IContentProposalEx> props = new ArrayList<IContentProposalEx>();
        String matchString = content.substring(0, cursorPosition);
        matchString = String.valueOf(matchString.toLowerCase()) + "*";
        NlsProposal[] nlsProposalArray = this.m_proposals;
        int n = this.m_proposals.length;
        int n2 = 0;
        while (n2 < n) {
            NlsProposal prop = nlsProposalArray[n2];
            if (CharOperation.match((char[])matchString.toCharArray(), (char[])prop.getLabel(false, false).toCharArray(), (boolean)false)) {
                props.add(prop);
            }
            ++n2;
        }
        props.add(new NlsNewProposal());
        return props.toArray(new IContentProposalEx[props.size()]);
    }

    @Override
    public IContentProposalEx[] getProposalsExpertMode(String content, int cursorPosition, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public boolean supportsExpertMode() {
        return false;
    }
}

